"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentListItem = void 0;
const React = require("react");
class ComponentListItem extends React.Component {
    constructor(props) {
        super(props);
        if (props.item.installable) {
            const version = props.item.availableVersions.filter((version) => version !== props.item.installedVersion)[0];
            this.state = {
                selectedVersion: version,
            };
        }
    }
    async install(item) {
        const toInstall = this.state.selectedVersion;
        const version = this.props.item.availableVersions.filter((version) => version !== this.state.selectedVersion)[0];
        this.setState({
            selectedVersion: version,
        });
        try {
            await this.props.install(item, toInstall);
        }
        catch (_a) {
            this.setState({
                selectedVersion: toInstall,
            });
        }
    }
    async uninstall(item) {
        await this.props.uninstall(item);
    }
    onVersionChange(version) {
        this.setState({ selectedVersion: version });
    }
    render() {
        const { item, itemRenderer } = this.props;
        return itemRenderer.renderItem(Object.assign(this.state, { item }), this.install.bind(this), this.uninstall.bind(this), this.onVersionChange.bind(this));
    }
}
exports.ComponentListItem = ComponentListItem;
//# sourceMappingURL=component-list-item.js.map