"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserStatus = void 0;
const React = require("react");
const disposable_1 = require("@theia/core/lib/common/disposable");
const cloud_user_commands_1 = require("../../auth/cloud-user-commands");
const common_1 = require("@theia/core/lib/common");
class UserStatus extends React.Component {
    constructor(props) {
        var _a;
        super(props);
        this.toDispose = new disposable_1.DisposableCollection();
        this.onDidClickRefresh = () => {
            this.setState({ refreshing: true });
            Promise.all([
                this.props.model.updateRoot(),
                new Promise((resolve) => setTimeout(() => resolve(true), 1000)),
            ]).then(() => {
                this.props.model.sketchbookTree().refresh();
                this.setState({ refreshing: false });
            });
        };
        this.state = {
            status: this.status,
            accountInfo: (_a = props.authenticationService.session) === null || _a === void 0 ? void 0 : _a.account,
            refreshing: false,
        };
    }
    componentDidMount() {
        const statusListener = () => this.setState({ status: this.status });
        window.addEventListener('online', statusListener);
        window.addEventListener('offline', statusListener);
        this.toDispose.pushAll([
            this.props.authenticationService.onSessionDidChange((session) => this.setState({ accountInfo: session === null || session === void 0 ? void 0 : session.account })),
            disposable_1.Disposable.create(() => window.removeEventListener('online', statusListener)),
            disposable_1.Disposable.create(() => window.removeEventListener('offline', statusListener)),
        ]);
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        var _a, _b;
        if (!this.props.authenticationService.session) {
            return null;
        }
        return (React.createElement("div", { className: "cloud-connection-status flex-line" },
            React.createElement("div", { className: "status item flex-line" },
                React.createElement("div", { className: `${this.state.status === 'connected'
                        ? 'connected-status-icon'
                        : 'offline-status-icon'}` }),
                this.state.status === 'connected'
                    ? common_1.nls.localize('arduino/cloud/connected', 'Connected')
                    : common_1.nls.localize('arduino/cloud/offline', 'Offline')),
            React.createElement("div", { className: "actions item flex-line" },
                React.createElement("div", { className: `fa fa-reload ${(this.state.refreshing && 'rotating') || ''}`, style: { cursor: 'pointer' }, onClick: this.onDidClickRefresh })),
            React.createElement("div", { className: "account item flex-line" },
                React.createElement("div", { className: "account-icon", style: { cursor: 'pointer' }, onClick: (event) => {
                        var _a;
                        event.preventDefault();
                        event.stopPropagation();
                        this.props.model.commandRegistry.executeCommand(cloud_user_commands_1.CloudUserCommands.OPEN_PROFILE_CONTEXT_MENU.id, {
                            event: event.nativeEvent,
                            username: (_a = this.state.accountInfo) === null || _a === void 0 ? void 0 : _a.label,
                        });
                    } }, ((_a = this.state.accountInfo) === null || _a === void 0 ? void 0 : _a.picture) && (React.createElement("img", { src: (_b = this.state.accountInfo) === null || _b === void 0 ? void 0 : _b.picture, alt: common_1.nls.localize('arduino/cloud/profilePicture', 'Profile picture') }))))));
    }
    get status() {
        return window.navigator.onLine ? 'connected' : 'offline';
    }
}
exports.UserStatus = UserStatus;
//# sourceMappingURL=cloud-user-status.js.map