"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookWidget = void 0;
const inversify_1 = require("inversify");
const cloud_sketchbook_composite_widget_1 = require("./cloud-sketchbook-composite-widget");
const sketchbook_widget_1 = require("../sketchbook/sketchbook-widget");
const arduino_preferences_1 = require("../../arduino-preferences");
let CloudSketchbookWidget = class CloudSketchbookWidget extends sketchbook_widget_1.SketchbookWidget {
    init() {
        super.init();
    }
    getTreeWidget() {
        const widget = this.sketchbookTreesContainer.selectedWidgets().next();
        if (widget && typeof widget.getTreeWidget !== 'undefined') {
            return widget.getTreeWidget();
        }
        return widget;
    }
    checkCloudEnabled() {
        if (this.arduinoPreferences['arduino.cloud.enabled']) {
            this.sketchbookTreesContainer.activateWidget(this.widget);
        }
        else {
            this.sketchbookTreesContainer.activateWidget(this.localSketchbookTreeWidget);
        }
        this.setDocumentMode();
    }
    setDocumentMode() {
        if (this.arduinoPreferences['arduino.cloud.enabled']) {
            this.sketchbookTreesContainer.mode = 'multiple-document';
        }
        else {
            this.sketchbookTreesContainer.mode = 'single-document';
        }
    }
    onAfterAttach(msg) {
        this.sketchbookTreesContainer.addWidget(this.widget);
        this.setDocumentMode();
        this.arduinoPreferences.onPreferenceChanged((event) => {
            if (event.preferenceName === 'arduino.cloud.enabled') {
                this.checkCloudEnabled();
            }
        });
        super.onAfterAttach(msg);
    }
};
__decorate([
    inversify_1.inject(cloud_sketchbook_composite_widget_1.CloudSketchbookCompositeWidget),
    __metadata("design:type", cloud_sketchbook_composite_widget_1.CloudSketchbookCompositeWidget)
], CloudSketchbookWidget.prototype, "widget", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], CloudSketchbookWidget.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CloudSketchbookWidget.prototype, "init", null);
CloudSketchbookWidget = __decorate([
    inversify_1.injectable()
], CloudSketchbookWidget);
exports.CloudSketchbookWidget = CloudSketchbookWidget;
//# sourceMappingURL=cloud-sketchbook-widget.js.map