"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __asyncValues = (this && this.__asyncValues) || function (o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookTreeModel = exports.sketchesToFileStats = exports.sketchBaseDir = void 0;
const inversify_1 = require("inversify");
const create_paths_1 = require("../../create/create-paths");
const create_api_1 = require("../../create/create-api");
const cloud_sketchbook_tree_1 = require("./cloud-sketchbook-tree");
const authentication_client_service_1 = require("../../auth/authentication-client-service");
const sketchbook_tree_model_1 = require("../sketchbook/sketchbook-tree-model");
const arduino_preferences_1 = require("../../arduino-preferences");
const navigator_tree_1 = require("@theia/navigator/lib/browser/navigator-tree");
const create_uri_1 = require("../../create/create-uri");
const local_cache_fs_provider_1 = require("../../local-cache/local-cache-fs-provider");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const cloud_sketch_cache_1 = require("./cloud-sketch-cache");
const common_1 = require("@theia/core/lib/common");
function sketchBaseDir(sketch) {
    // extract the sketch path
    const [, path] = create_paths_1.splitSketchPath(sketch.path);
    const dirs = create_paths_1.posixSegments(path);
    const mtime = Date.parse(sketch.modified_at);
    const ctime = Date.parse(sketch.created_at);
    const createPath = create_uri_1.CreateUri.toUri(dirs[0]);
    const baseDir = {
        name: dirs[0],
        isDirectory: true,
        isFile: false,
        isSymbolicLink: false,
        resource: createPath,
        mtime,
        ctime,
    };
    return baseDir;
}
exports.sketchBaseDir = sketchBaseDir;
function sketchesToFileStats(sketches) {
    const sketchesBaseDirs = {};
    for (const sketch of sketches) {
        const sketchBaseDirFileStat = sketchBaseDir(sketch);
        sketchesBaseDirs[sketchBaseDirFileStat.resource.toString()] =
            sketchBaseDirFileStat;
    }
    return Object.keys(sketchesBaseDirs).map((dirUri) => sketchesBaseDirs[dirUri]);
}
exports.sketchesToFileStats = sketchesToFileStats;
let CloudSketchbookTreeModel = class CloudSketchbookTreeModel extends sketchbook_tree_model_1.SketchbookTreeModel {
    init() {
        super.init();
        this.toDispose.push(this.authenticationService.onSessionDidChange(() => this.updateRoot()));
    }
    async createRoot() {
        var e_1, _a;
        const { session } = this.authenticationService;
        if (!session) {
            this.tree.root = undefined;
            return;
        }
        this.createApi.init(this.authenticationService, this.arduinoPreferences);
        this.sketchCache.init();
        const sketches = await this.createApi.sketches();
        const rootFileStats = sketchesToFileStats(sketches);
        if (this.workspaceService.opened) {
            const workspaceNode = navigator_tree_1.WorkspaceNode.createRoot(common_1.nls.localize('arduino/cloud/remote', 'Remote'));
            try {
                for (var rootFileStats_1 = __asyncValues(rootFileStats), rootFileStats_1_1; rootFileStats_1_1 = await rootFileStats_1.next(), !rootFileStats_1_1.done;) {
                    const stat = rootFileStats_1_1.value;
                    workspaceNode.children.push(await this.tree.createWorkspaceRoot(stat, workspaceNode));
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (rootFileStats_1_1 && !rootFileStats_1_1.done && (_a = rootFileStats_1.return)) await _a.call(rootFileStats_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return workspaceNode;
        }
    }
    sketchbookTree() {
        return this.tree;
    }
    recursivelyFindSketchRoot(node) {
        if (node && cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(node)) {
            return node;
        }
        if (node && node.parent) {
            return this.recursivelyFindSketchRoot(node.parent);
        }
        // can't find a root, return false
        return false;
    }
    async revealFile(uri) {
        // we use remote uris as keys for the tree
        // convert local URIs
        const remoteuri = this.localCacheFsProvider.from(uri);
        if (remoteuri) {
            return super.revealFile(remoteuri);
        }
        else {
            return super.revealFile(uri);
        }
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], CloudSketchbookTreeModel.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(authentication_client_service_1.AuthenticationClientService),
    __metadata("design:type", authentication_client_service_1.AuthenticationClientService)
], CloudSketchbookTreeModel.prototype, "authenticationService", void 0);
__decorate([
    inversify_1.inject(create_api_1.CreateApi),
    __metadata("design:type", create_api_1.CreateApi)
], CloudSketchbookTreeModel.prototype, "createApi", void 0);
__decorate([
    inversify_1.inject(cloud_sketchbook_tree_1.CloudSketchbookTree),
    __metadata("design:type", cloud_sketchbook_tree_1.CloudSketchbookTree)
], CloudSketchbookTreeModel.prototype, "cloudSketchbookTree", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], CloudSketchbookTreeModel.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.inject(local_cache_fs_provider_1.LocalCacheFsProvider),
    __metadata("design:type", local_cache_fs_provider_1.LocalCacheFsProvider)
], CloudSketchbookTreeModel.prototype, "localCacheFsProvider", void 0);
__decorate([
    inversify_1.inject(cloud_sketch_cache_1.SketchCache),
    __metadata("design:type", cloud_sketch_cache_1.SketchCache)
], CloudSketchbookTreeModel.prototype, "sketchCache", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], CloudSketchbookTreeModel.prototype, "init", null);
CloudSketchbookTreeModel = __decorate([
    inversify_1.injectable()
], CloudSketchbookTreeModel);
exports.CloudSketchbookTreeModel = CloudSketchbookTreeModel;
//# sourceMappingURL=cloud-sketchbook-tree-model.js.map