"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookContribution = exports.CloudSketchbookCommands = exports.CLOUD_USER__CONTEXT__MAIN_GROUP = exports.CLOUD_USER__CONTEXT__USERNAME = exports.CLOUD_USER__CONTEXT = exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP = exports.SKETCHBOOKSYNC__CONTEXT = void 0;
const inversify_1 = require("inversify");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const command_1 = require("@theia/core/lib/common/command");
const browser_1 = require("@theia/core/lib/browser");
const disposable_1 = require("@theia/core/lib/common/disposable");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const menu_1 = require("@theia/core/lib/common/menu");
const cloud_sketchbook_tree_1 = require("./cloud-sketchbook-tree");
const cloud_sketchbook_tree_model_1 = require("./cloud-sketchbook-tree-model");
const cloud_user_commands_1 = require("../../auth/cloud-user-commands");
const cloud_share_sketch_dialog_1 = require("../../dialogs/cloud-share-sketch-dialog");
const create_api_1 = require("../../create/create-api");
const preference_service_1 = require("@theia/core/lib/browser/preferences/preference-service");
const arduino_menus_1 = require("../../menu/arduino-menus");
const sketchbook_commands_1 = require("../sketchbook/sketchbook-commands");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const contribution_1 = require("../../contributions/contribution");
const arduino_preferences_1 = require("../../arduino-preferences");
const main_menu_manager_1 = require("../../../common/main-menu-manager");
const common_1 = require("@theia/core/lib/common");
exports.SKETCHBOOKSYNC__CONTEXT = ['arduino-sketchbook-sync--context'];
// `Open Folder`, `Open in New Window`
exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP = [
    ...exports.SKETCHBOOKSYNC__CONTEXT,
    '0_main',
];
exports.CLOUD_USER__CONTEXT = ['arduino-cloud-user--context'];
exports.CLOUD_USER__CONTEXT__USERNAME = [
    ...exports.CLOUD_USER__CONTEXT,
    '0_username',
];
exports.CLOUD_USER__CONTEXT__MAIN_GROUP = [
    ...exports.CLOUD_USER__CONTEXT,
    '1_main',
];
var CloudSketchbookCommands;
(function (CloudSketchbookCommands) {
    let Arg;
    (function (Arg) {
        function is(arg) {
            return (!!arg && !!arg.node && arg.model instanceof cloud_sketchbook_tree_model_1.CloudSketchbookTreeModel);
        }
        Arg.is = is;
    })(Arg = CloudSketchbookCommands.Arg || (CloudSketchbookCommands.Arg = {}));
    CloudSketchbookCommands.TOGGLE_CLOUD_SKETCHBOOK = command_1.Command.toLocalizedCommand({
        id: 'arduino-cloud-sketchbook--disable',
        label: 'Show/Hide Remote Sketchbook',
    }, 'arduino/cloud/showHideRemoveSketchbook');
    CloudSketchbookCommands.PULL_SKETCH = command_1.Command.toLocalizedCommand({
        id: 'arduino-cloud-sketchbook--pull-sketch',
        label: 'Pull Sketch',
        iconClass: 'pull-sketch-icon',
    }, 'arduino/cloud/pullSketch');
    CloudSketchbookCommands.PUSH_SKETCH = command_1.Command.toLocalizedCommand({
        id: 'arduino-cloud-sketchbook--push-sketch',
        label: 'Push Sketch',
        iconClass: 'push-sketch-icon',
    }, 'arduino/cloud/pullSketch');
    CloudSketchbookCommands.OPEN_IN_CLOUD_EDITOR = command_1.Command.toLocalizedCommand({
        id: 'arduino-cloud-sketchbook--open-in-cloud-editor',
        label: 'Open in Cloud Editor',
    }, 'arduino/cloud/openInCloudEditor');
    CloudSketchbookCommands.OPEN_SKETCHBOOKSYNC_CONTEXT_MENU = command_1.Command.toLocalizedCommand({
        id: 'arduino-sketchbook-sync--open-sketch-context-menu',
        label: 'Options...',
        iconClass: 'sketchbook-tree__opts',
    }, 'arduino/cloud/options');
    CloudSketchbookCommands.OPEN_SKETCH_SHARE_DIALOG = command_1.Command.toLocalizedCommand({
        id: 'arduino-cloud-sketchbook--share-modal',
        label: 'Share...',
    }, 'arduino/cloud/share');
    CloudSketchbookCommands.OPEN_PROFILE_CONTEXT_MENU = {
        id: 'arduino-cloud-sketchbook--open-profile-menu',
        label: 'Contextual menu',
    };
})(CloudSketchbookCommands = exports.CloudSketchbookCommands || (exports.CloudSketchbookCommands = {}));
let CloudSketchbookContribution = class CloudSketchbookContribution extends contribution_1.Contribution {
    constructor() {
        super(...arguments);
        this.toDisposeBeforeNewContextMenu = new disposable_1.DisposableCollection();
    }
    registerMenus(menus) {
        menus.registerMenuAction(arduino_menus_1.ArduinoMenus.FILE__ADVANCED_SUBMENU, {
            commandId: CloudSketchbookCommands.TOGGLE_CLOUD_SKETCHBOOK.id,
            label: CloudSketchbookCommands.TOGGLE_CLOUD_SKETCHBOOK.label,
            order: '2',
        });
    }
    registerCommands(registry) {
        registry.registerCommand(CloudSketchbookCommands.TOGGLE_CLOUD_SKETCHBOOK, {
            execute: () => {
                this.preferenceService.set('arduino.cloud.enabled', !this.arduinoPreferences['arduino.cloud.enabled'], preference_service_1.PreferenceScope.User);
            },
            isEnabled: () => true,
            isVisible: () => true,
        });
        registry.registerCommand(CloudSketchbookCommands.PULL_SKETCH, {
            execute: (arg) => arg.model.sketchbookTree().pull(arg),
            isEnabled: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
            isVisible: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
        });
        registry.registerCommand(CloudSketchbookCommands.PUSH_SKETCH, {
            execute: (arg) => arg.model.sketchbookTree().push(arg.node),
            isEnabled: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchTreeNode.isSynced(arg.node),
            isVisible: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchTreeNode.isSynced(arg.node),
        });
        registry.registerCommand(CloudSketchbookCommands.OPEN_IN_CLOUD_EDITOR, {
            execute: (arg) => {
                this.windowService.openNewWindow(`https://create.arduino.cc/editor/${arg.username}/${arg.node.sketchId}`, { external: true });
            },
            isEnabled: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
            isVisible: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
        });
        registry.registerCommand(CloudSketchbookCommands.OPEN_SKETCH_SHARE_DIALOG, {
            execute: (arg) => {
                new cloud_share_sketch_dialog_1.ShareSketchDialog({
                    node: arg.node,
                    title: common_1.nls.localize('arduino/cloud/shareSketch', 'Share Sketch'),
                    createApi: this.createApi,
                }).open();
            },
            isEnabled: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
            isVisible: (arg) => CloudSketchbookCommands.Arg.is(arg) &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
        });
        registry.registerCommand(CloudSketchbookCommands.OPEN_SKETCHBOOKSYNC_CONTEXT_MENU, {
            isEnabled: (arg) => !!arg &&
                'node' in arg &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
            isVisible: (arg) => !!arg &&
                'node' in arg &&
                cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchDirNode.is(arg.node),
            execute: async (arg) => {
                // cleanup previous context menu entries
                this.toDisposeBeforeNewContextMenu.dispose();
                const container = arg.event.target;
                if (!container) {
                    return;
                }
                this.menuRegistry.registerMenuAction(exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP, {
                    commandId: CloudSketchbookCommands.OPEN_IN_CLOUD_EDITOR.id,
                    label: CloudSketchbookCommands.OPEN_IN_CLOUD_EDITOR.label,
                    order: '0',
                });
                this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(CloudSketchbookCommands.OPEN_IN_CLOUD_EDITOR)));
                this.menuRegistry.registerMenuAction(exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP, {
                    commandId: CloudSketchbookCommands.OPEN_SKETCH_SHARE_DIALOG.id,
                    label: CloudSketchbookCommands.OPEN_SKETCH_SHARE_DIALOG.label,
                    order: '1',
                });
                this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(CloudSketchbookCommands.OPEN_SKETCH_SHARE_DIALOG)));
                const currentSketch = await this.sketchServiceClient.currentSketch();
                // disable the "open sketch" command for the current sketch and for those not in sync
                if (!cloud_sketchbook_tree_1.CloudSketchbookTree.CloudSketchTreeNode.isSynced(arg.node) ||
                    (currentSketch && currentSketch.uri === arg.node.uri.toString())) {
                    const placeholder = new arduino_menus_1.PlaceholderMenuNode(exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP, sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.label);
                    this.menuRegistry.registerMenuNode(exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP, placeholder);
                    this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(placeholder.id)));
                }
                else {
                    this.menuRegistry.registerMenuAction(exports.SKETCHBOOKSYNC__CONTEXT__MAIN_GROUP, {
                        commandId: sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.id,
                        label: sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW.label,
                    });
                    this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(sketchbook_commands_1.SketchbookCommands.OPEN_NEW_WINDOW)));
                }
                const options = {
                    menuPath: exports.SKETCHBOOKSYNC__CONTEXT,
                    anchor: {
                        x: container.getBoundingClientRect().left,
                        y: container.getBoundingClientRect().top + container.offsetHeight,
                    },
                    args: [arg],
                };
                this.contextMenuRenderer.render(options);
            },
        });
        registry.registerCommand(cloud_user_commands_1.CloudUserCommands.OPEN_PROFILE_CONTEXT_MENU, {
            execute: async (arg) => {
                this.toDisposeBeforeNewContextMenu.dispose();
                const container = arg.event.target;
                if (!container) {
                    return;
                }
                this.menuRegistry.registerMenuAction(exports.CLOUD_USER__CONTEXT__MAIN_GROUP, {
                    commandId: cloud_user_commands_1.CloudUserCommands.LOGOUT.id,
                    label: cloud_user_commands_1.CloudUserCommands.LOGOUT.label,
                });
                this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuAction(cloud_user_commands_1.CloudUserCommands.LOGOUT)));
                const placeholder = new arduino_menus_1.PlaceholderMenuNode(exports.CLOUD_USER__CONTEXT__USERNAME, arg.username);
                this.menuRegistry.registerMenuNode(exports.CLOUD_USER__CONTEXT__USERNAME, placeholder);
                this.toDisposeBeforeNewContextMenu.push(disposable_1.Disposable.create(() => this.menuRegistry.unregisterMenuNode(placeholder.id)));
                const options = {
                    menuPath: exports.CLOUD_USER__CONTEXT,
                    anchor: {
                        x: container.getBoundingClientRect().left,
                        y: container.getBoundingClientRect().top -
                            3.5 * container.offsetHeight,
                    },
                    args: [arg],
                };
                this.contextMenuRenderer.render(options);
            },
        });
        this.registerMenus(this.menuRegistry);
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], CloudSketchbookContribution.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(browser_1.ContextMenuRenderer),
    __metadata("design:type", browser_1.ContextMenuRenderer)
], CloudSketchbookContribution.prototype, "contextMenuRenderer", void 0);
__decorate([
    inversify_1.inject(menu_1.MenuModelRegistry),
    __metadata("design:type", menu_1.MenuModelRegistry)
], CloudSketchbookContribution.prototype, "menuRegistry", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], CloudSketchbookContribution.prototype, "sketchServiceClient", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], CloudSketchbookContribution.prototype, "windowService", void 0);
__decorate([
    inversify_1.inject(create_api_1.CreateApi),
    __metadata("design:type", create_api_1.CreateApi)
], CloudSketchbookContribution.prototype, "createApi", void 0);
__decorate([
    inversify_1.inject(arduino_preferences_1.ArduinoPreferences),
    __metadata("design:type", Object)
], CloudSketchbookContribution.prototype, "arduinoPreferences", void 0);
__decorate([
    inversify_1.inject(preference_service_1.PreferenceService),
    __metadata("design:type", Object)
], CloudSketchbookContribution.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(main_menu_manager_1.MainMenuManager),
    __metadata("design:type", Object)
], CloudSketchbookContribution.prototype, "mainMenuManager", void 0);
CloudSketchbookContribution = __decorate([
    inversify_1.injectable()
], CloudSketchbookContribution);
exports.CloudSketchbookContribution = CloudSketchbookContribution;
//# sourceMappingURL=cloud-sketchbook-contributions.js.map