"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudSketchbookCompositeWidget = void 0;
const React = require("react");
const ReactDOM = require("react-dom");
const inversify_1 = require("inversify");
const widgets_1 = require("@phosphor/widgets");
const messaging_1 = require("@phosphor/messaging");
const disposable_1 = require("@theia/core/lib/common/disposable");
const widget_1 = require("@theia/core/lib/browser/widgets/widget");
const cloud_user_status_1 = require("./cloud-user-status");
const cloud_sketchbook_tree_widget_1 = require("./cloud-sketchbook-tree-widget");
const authentication_client_service_1 = require("../../auth/authentication-client-service");
const common_1 = require("@theia/core/lib/common");
let CloudSketchbookCompositeWidget = class CloudSketchbookCompositeWidget extends widget_1.BaseWidget {
    constructor() {
        super();
        this.compositeNode = document.createElement('div');
        this.compositeNode.classList.add('composite-node');
        this.cloudUserStatusNode = document.createElement('div');
        this.cloudUserStatusNode.classList.add('cloud-status-node');
        this.compositeNode.appendChild(this.cloudUserStatusNode);
        this.node.appendChild(this.compositeNode);
        this.title.caption = common_1.nls.localize('arduino/cloud/cloudSketchbook', 'Cloud Sketchbook');
        this.title.iconClass = 'cloud-sketchbook-tree-icon';
        this.title.closable = false;
        this.id = 'cloud-sketchbook-composite-widget';
    }
    getTreeWidget() {
        return this.cloudSketchbookTreeWidget;
    }
    onAfterAttach(message) {
        super.onAfterAttach(message);
        widgets_1.Widget.attach(this.cloudSketchbookTreeWidget, this.compositeNode);
        ReactDOM.render(React.createElement(cloud_user_status_1.UserStatus, { model: this.cloudSketchbookTreeWidget.model, authenticationService: this.authenticationService }), this.cloudUserStatusNode);
        this.toDisposeOnDetach.push(disposable_1.Disposable.create(() => widgets_1.Widget.detach(this.cloudSketchbookTreeWidget)));
    }
    onResize(message) {
        super.onResize(message);
        messaging_1.MessageLoop.sendMessage(this.cloudSketchbookTreeWidget, widgets_1.Widget.ResizeMessage.UnknownSize);
    }
};
__decorate([
    inversify_1.inject(authentication_client_service_1.AuthenticationClientService),
    __metadata("design:type", authentication_client_service_1.AuthenticationClientService)
], CloudSketchbookCompositeWidget.prototype, "authenticationService", void 0);
__decorate([
    inversify_1.inject(cloud_sketchbook_tree_widget_1.CloudSketchbookTreeWidget),
    __metadata("design:type", cloud_sketchbook_tree_widget_1.CloudSketchbookTreeWidget)
], CloudSketchbookCompositeWidget.prototype, "cloudSketchbookTreeWidget", void 0);
CloudSketchbookCompositeWidget = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], CloudSketchbookCompositeWidget);
exports.CloudSketchbookCompositeWidget = CloudSketchbookCompositeWidget;
//# sourceMappingURL=cloud-sketchbook-composite-widget.js.map