"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SketchCache = void 0;
const inversify_1 = require("inversify");
const create_paths_1 = require("../../create/create-paths");
let SketchCache = class SketchCache {
    constructor() {
        this.sketches = {};
        this.fileStats = {};
    }
    init() {
        // reset the data
        this.sketches = {};
        this.fileStats = {};
    }
    addItem(item) {
        this.fileStats[item.resource.path.toString()] = item;
    }
    getItem(path) {
        return this.fileStats[path] || null;
    }
    purgeByPath(path) {
        for (const itemPath in this.fileStats) {
            if (itemPath.indexOf(path) === 0) {
                delete this.fileStats[itemPath];
            }
        }
    }
    addSketch(sketch) {
        const { path } = sketch;
        const posixPath = create_paths_1.toPosixPath(path);
        this.sketches[posixPath] = sketch;
    }
    getSketch(path) {
        return this.sketches[path] || null;
    }
};
SketchCache = __decorate([
    inversify_1.injectable()
], SketchCache);
exports.SketchCache = SketchCache;
//# sourceMappingURL=cloud-sketch-cache.js.map