"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceVariableContribution = void 0;
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const workspace_variable_contribution_1 = require("@theia/workspace/lib/browser/workspace-variable-contribution");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
let WorkspaceVariableContribution = class WorkspaceVariableContribution extends workspace_variable_contribution_1.WorkspaceVariableContribution {
    init() {
        this.sketchesServiceClient
            .currentSketch()
            .then()
            .then((sketch) => (this.currentSketch = sketch));
    }
    getResourceUri() {
        var _a;
        const resourceUri = super.getResourceUri();
        // https://github.com/arduino/arduino-ide/issues/46
        // `currentWidget` can be an editor representing a file outside of the workspace. The current sketch should be a fallback.
        if (!resourceUri && ((_a = this.currentSketch) === null || _a === void 0 ? void 0 : _a.uri)) {
            return new uri_1.default(this.currentSketch.uri);
        }
        return resourceUri;
    }
};
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], WorkspaceVariableContribution.prototype, "sketchesServiceClient", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], WorkspaceVariableContribution.prototype, "init", null);
WorkspaceVariableContribution = __decorate([
    inversify_1.injectable()
], WorkspaceVariableContribution);
exports.WorkspaceVariableContribution = WorkspaceVariableContribution;
//# sourceMappingURL=workspace-variable-contribution.js.map