"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceService = void 0;
const remote = require("@theia/core/electron-shared/@electron/remote");
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const browser_1 = require("@theia/editor/lib/browser");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const message_service_1 = require("@theia/core/lib/common/message-service");
const application_protocol_1 = require("@theia/core/lib/common/application-protocol");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const config_service_1 = require("../../../common/protocol/config-service");
const sketches_service_1 = require("../../../common/protocol/sketches-service");
const arduino_workspace_resolver_1 = require("../../arduino-workspace-resolver");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const boards_config_1 = require("../../boards/boards-config");
const common_1 = require("@theia/core/lib/common");
const vscode_uri_1 = require("@theia/core/shared/vscode-uri");
let WorkspaceService = class WorkspaceService extends workspace_service_1.WorkspaceService {
    async onStart(application) {
        this.application = application;
        const info = await this.applicationServer.getApplicationInfo();
        this.version = info === null || info === void 0 ? void 0 : info.version;
        application.shell.onDidChangeCurrentWidget(this.onCurrentWidgetChange.bind(this));
        const newValue = application.shell.currentWidget
            ? application.shell.currentWidget
            : null;
        this.onCurrentWidgetChange({ newValue, oldValue: null });
    }
    getDefaultWorkspaceUri() {
        if (this.workspaceUri) {
            // Avoid creating a new sketch twice
            return this.workspaceUri;
        }
        this.workspaceUri = (async () => {
            try {
                const hash = window.location.hash;
                const [recentWorkspacesPaths, recentSketches] = await Promise.all([
                    this.server.getRecentWorkspaces(),
                    this.sketchService
                        .getSketches({})
                        .then((container) => sketches_service_1.SketchContainer.toArray(container).map((s) => s.uri)),
                ]);
                // On Dindows, `getRecentWorkspaces` returns only file paths, not URIs as expected by the `isValid` method.
                const recentWorkspaces = recentWorkspacesPaths.map((e) => vscode_uri_1.URI.file(e).toString());
                const toOpen = await new arduino_workspace_resolver_1.ArduinoWorkspaceRootResolver({
                    isValid: this.isValid.bind(this),
                }).resolve({ hash, recentWorkspaces, recentSketches });
                if (toOpen) {
                    const { uri } = toOpen;
                    await this.server.setMostRecentlyUsedWorkspace(uri);
                    return toOpen.uri;
                }
                return (await this.sketchService.createNewSketch()).uri;
            }
            catch (err) {
                this.appStateService
                    .reachedState('ready')
                    .then(() => this.application.shell.update());
                this.logger.fatal(`Failed to determine the sketch directory: ${err}`);
                this.messageService.error(common_1.nls.localize('theia/workspace/sketchDirectoryError', 'There was an error creating the sketch directory. See the log for more details. The application will probably not work as expected.'));
                return super.getDefaultWorkspaceUri();
            }
        })();
        return this.workspaceUri;
    }
    openNewWindow(workspacePath) {
        const { boardsConfig } = this.boardsServiceProvider;
        const url = boards_config_1.BoardsConfig.Config.setConfig(boardsConfig, new URL(window.location.href)); // Set the current boards config for the new browser window.
        url.hash = workspacePath;
        this.windowService.openNewWindow(url.toString());
    }
    async isValid(uri) {
        const exists = await this.fileService.exists(new uri_1.default(uri));
        if (!exists) {
            return false;
        }
        return this.sketchService.isSketchFolder(uri);
    }
    onCurrentWidgetChange({ newValue, }) {
        if (newValue instanceof browser_1.EditorWidget) {
            const { uri } = newValue.editor;
            const currentWindow = remote.getCurrentWindow();
            currentWindow.setRepresentedFilename(uri.path.toString());
            if (sketches_service_1.Sketch.isSketchFile(uri.toString())) {
                this.updateTitle();
            }
            else {
                const title = this.workspaceTitle;
                const fileName = this.labelProvider.getName(uri);
                document.title = this.formatTitle(title ? `${title} - ${fileName}` : fileName);
            }
        }
        else {
            this.updateTitle();
        }
    }
    formatTitle(title) {
        const version = this.version ? ` ${this.version}` : '';
        const name = `${this.applicationName} ${version}`;
        return title ? `${title} | ${name}` : name;
    }
    get workspaceTitle() {
        if (this.workspace) {
            return this.labelProvider.getName(this.workspace.resource);
        }
    }
};
__decorate([
    inversify_1.inject(sketches_service_1.SketchesService),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "sketchService", void 0);
__decorate([
    inversify_1.inject(config_service_1.ConfigService),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "configService", void 0);
__decorate([
    inversify_1.inject(label_provider_1.LabelProvider),
    __metadata("design:type", label_provider_1.LabelProvider)
], WorkspaceService.prototype, "labelProvider", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], WorkspaceService.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(application_protocol_1.ApplicationServer),
    __metadata("design:type", Object)
], WorkspaceService.prototype, "applicationServer", void 0);
__decorate([
    inversify_1.inject(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], WorkspaceService.prototype, "appStateService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], WorkspaceService.prototype, "boardsServiceProvider", void 0);
WorkspaceService = __decorate([
    inversify_1.injectable()
], WorkspaceService);
exports.WorkspaceService = WorkspaceService;
//# sourceMappingURL=workspace-service.js.map