"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceInputDialog = void 0;
const inversify_1 = require("inversify");
const label_provider_1 = require("@theia/core/lib/browser/label-provider");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const workspace_input_dialog_1 = require("@theia/workspace/lib/browser/workspace-input-dialog");
const common_1 = require("@theia/core/lib/common");
let WorkspaceInputDialog = class WorkspaceInputDialog extends workspace_input_dialog_1.WorkspaceInputDialog {
    constructor(props, labelProvider) {
        super(props, labelProvider);
        this.props = props;
        this.labelProvider = labelProvider;
        this.wasTouched = false;
        this.appendCloseButton(common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'));
    }
    appendParentPath() {
        // NOOP
    }
    isValid(value, mode) {
        if (value !== '') {
            this.wasTouched = true;
        }
        return super.isValid(value, mode);
    }
    setErrorMessage(error) {
        if (this.acceptButton) {
            this.acceptButton.disabled = !dialogs_1.DialogError.getResult(error);
        }
        if (this.wasTouched) {
            this.errorMessageNode.innerText = dialogs_1.DialogError.getMessage(error);
        }
    }
};
WorkspaceInputDialog = __decorate([
    __param(0, inversify_1.inject(workspace_input_dialog_1.WorkspaceInputDialogProps)),
    __param(1, inversify_1.inject(label_provider_1.LabelProvider)),
    __metadata("design:paramtypes", [workspace_input_dialog_1.WorkspaceInputDialogProps,
        label_provider_1.LabelProvider])
], WorkspaceInputDialog);
exports.WorkspaceInputDialog = WorkspaceInputDialog;
//# sourceMappingURL=workspace-input-dialog.js.map