"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArduinoFileMenuContribution = exports.WorkspaceFrontendContribution = void 0;
const inversify_1 = require("inversify");
const workspace_commands_1 = require("@theia/workspace/lib/browser/workspace-commands");
const workspace_frontend_contribution_1 = require("@theia/workspace/lib/browser/workspace-frontend-contribution");
let WorkspaceFrontendContribution = class WorkspaceFrontendContribution extends workspace_frontend_contribution_1.WorkspaceFrontendContribution {
    registerCommands(registry) {
        super.registerCommands(registry);
        // TODO: instead of blacklisting commands to remove, it would be more robust to whitelist the ones we want to keep
        const commands = new Set(registry.commands);
        [
            workspace_commands_1.WorkspaceCommands.OPEN,
            workspace_commands_1.WorkspaceCommands.OPEN_FILE,
            workspace_commands_1.WorkspaceCommands.OPEN_FOLDER,
            workspace_commands_1.WorkspaceCommands.OPEN_WORKSPACE,
            workspace_commands_1.WorkspaceCommands.OPEN_RECENT_WORKSPACE,
            workspace_commands_1.WorkspaceCommands.SAVE_WORKSPACE_AS,
            workspace_commands_1.WorkspaceCommands.SAVE_AS,
            workspace_commands_1.WorkspaceCommands.CLOSE,
        ]
            .filter(commands.has.bind(commands))
            .forEach(registry.unregisterCommand.bind(registry));
    }
    registerMenus(_) { }
    registerKeybindings(registry) {
        super.registerKeybindings(registry);
        [
            workspace_commands_1.WorkspaceCommands.NEW_FILE,
            workspace_commands_1.WorkspaceCommands.FILE_RENAME,
            workspace_commands_1.WorkspaceCommands.FILE_DELETE,
        ]
            .map(({ id }) => id)
            .forEach(registry.unregisterKeybinding.bind(registry));
    }
};
WorkspaceFrontendContribution = __decorate([
    inversify_1.injectable()
], WorkspaceFrontendContribution);
exports.WorkspaceFrontendContribution = WorkspaceFrontendContribution;
let ArduinoFileMenuContribution = class ArduinoFileMenuContribution extends workspace_commands_1.FileMenuContribution {
    registerMenus(_) {
        // NOOP
    }
};
ArduinoFileMenuContribution = __decorate([
    inversify_1.injectable()
], ArduinoFileMenuContribution);
exports.ArduinoFileMenuContribution = ArduinoFileMenuContribution;
//# sourceMappingURL=workspace-frontend-contribution.js.map