"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WorkspaceCommandContribution = void 0;
const inversify_1 = require("inversify");
const opener_service_1 = require("@theia/core/lib/browser/opener-service");
const command_1 = require("@theia/core/lib/common/command");
const workspace_commands_1 = require("@theia/workspace/lib/browser/workspace-commands");
const protocol_1 = require("../../../common/protocol");
const workspace_input_dialog_1 = require("./workspace-input-dialog");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const save_as_sketch_1 = require("../../contributions/save-as-sketch");
const browser_1 = require("@theia/core/lib/browser");
const common_1 = require("@theia/core/lib/common");
let WorkspaceCommandContribution = class WorkspaceCommandContribution extends workspace_commands_1.WorkspaceCommandContribution {
    registerCommands(registry) {
        super.registerCommands(registry);
        registry.unregisterCommand(workspace_commands_1.WorkspaceCommands.NEW_FILE);
        registry.registerCommand(workspace_commands_1.WorkspaceCommands.NEW_FILE, this.newWorkspaceRootUriAwareCommandHandler({
            execute: (uri) => this.newFile(uri),
        }));
        registry.unregisterCommand(workspace_commands_1.WorkspaceCommands.FILE_RENAME);
        registry.registerCommand(workspace_commands_1.WorkspaceCommands.FILE_RENAME, this.newUriAwareCommandHandler({
            execute: (uri) => this.renameFile(uri),
        }));
    }
    async newFile(uri) {
        if (!uri) {
            return;
        }
        const parent = await this.getDirectory(uri);
        if (!parent) {
            return;
        }
        const parentUri = parent.resource;
        const dialog = new workspace_input_dialog_1.WorkspaceInputDialog({
            title: common_1.nls.localize('theia/workspace/fileNewName', 'Name for new file'),
            parentUri,
            validate: (name) => this.validateFileName(name, parent, true),
        }, this.labelProvider);
        const name = await dialog.open();
        const nameWithExt = this.maybeAppendInoExt(name);
        if (nameWithExt) {
            const fileUri = parentUri.resolve(nameWithExt);
            await this.fileService.createFile(fileUri);
            this.fireCreateNewFile({ parent: parentUri, uri: fileUri });
            opener_service_1.open(this.openerService, fileUri);
        }
    }
    async validateFileName(name, parent, recursive = false) {
        // In the Java IDE the followings are the rules:
        //  - `name` without an extension should default to `name.ino`.
        //  - `name` with a single trailing `.` also defaults to `name.ino`.
        const nameWithExt = this.maybeAppendInoExt(name);
        const errorMessage = await super.validateFileName(nameWithExt, parent, recursive);
        if (errorMessage) {
            return errorMessage;
        }
        const extension = nameWithExt.split('.').pop();
        if (!extension) {
            return common_1.nls.localize('theia/workspace/invalidFilename', 'Invalid filename.'); // XXX: this should not happen as we forcefully append `.ino` if it's not there.
        }
        if (protocol_1.Sketch.Extensions.ALL.indexOf(`.${extension}`) === -1) {
            return common_1.nls.localize('theia/workspace/invalidExtension', '.{0} is not a valid extension', extension);
        }
        return '';
    }
    maybeAppendInoExt(name) {
        if (!name) {
            return '';
        }
        if (name.trim().length) {
            if (name.indexOf('.') === -1) {
                return `${name}.ino`;
            }
            if (name.lastIndexOf('.') === name.length - 1) {
                return `${name.slice(0, -1)}.ino`;
            }
        }
        return name;
    }
    async renameFile(uri) {
        if (!uri) {
            return;
        }
        const sketch = await this.sketchesServiceClient.currentSketch();
        if (!sketch) {
            return;
        }
        // file belongs to another sketch, do not allow rename
        const parentsketch = await this.sketchService.getSketchFolder(uri.toString());
        if (parentsketch && parentsketch.uri !== sketch.uri) {
            return;
        }
        if (uri.toString() === sketch.mainFileUri) {
            const options = {
                execOnlyIfTemp: false,
                openAfterMove: true,
                wipeOriginal: true,
            };
            await this.commandService.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, options);
            return;
        }
        const parent = await this.getParent(uri);
        if (!parent) {
            return;
        }
        const initialValue = uri.path.base;
        const dialog = new browser_1.SingleTextInputDialog({
            title: common_1.nls.localize('theia/workspace/newFileName', 'New name for file'),
            initialValue,
            initialSelectionRange: {
                start: 0,
                end: uri.path.name.length,
            },
            validate: (name, mode) => {
                if (initialValue === name && mode === 'preview') {
                    return false;
                }
                return this.validateFileName(name, parent, false);
            },
        });
        const newName = await dialog.open();
        const newNameWithExt = this.maybeAppendInoExt(newName);
        if (newNameWithExt) {
            const oldUri = uri;
            const newUri = uri.parent.resolve(newNameWithExt);
            this.fileService.move(oldUri, newUri);
        }
    }
};
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], WorkspaceCommandContribution.prototype, "sketchesServiceClient", void 0);
__decorate([
    inversify_1.inject(command_1.CommandService),
    __metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "commandService", void 0);
__decorate([
    inversify_1.inject(protocol_1.SketchesService),
    __metadata("design:type", Object)
], WorkspaceCommandContribution.prototype, "sketchService", void 0);
WorkspaceCommandContribution = __decorate([
    inversify_1.injectable()
], WorkspaceCommandContribution);
exports.WorkspaceCommandContribution = WorkspaceCommandContribution;
//# sourceMappingURL=workspace-commands.js.map