"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferencesContribution = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/core/lib/browser");
const preferences_contribution_1 = require("@theia/preferences/lib/browser/preferences-contribution");
let PreferencesContribution = class PreferencesContribution extends preferences_contribution_1.PreferencesContribution {
    registerMenus(registry) {
        super.registerMenus(registry);
        // The settings group: preferences, CLI config is not part of the `File` menu on macOS.
        // On Windows and Linux, we rebind it to `Preferences...`. It is safe to remove here.
        registry.unregisterMenuAction(browser_1.CommonCommands.OPEN_PREFERENCES.id, browser_1.CommonMenus.FILE_SETTINGS_SUBMENU_OPEN);
    }
    registerKeybindings(registry) {
        registry.unregisterKeybinding(browser_1.CommonCommands.OPEN_PREFERENCES.id);
    }
};
PreferencesContribution = __decorate([
    inversify_1.injectable()
], PreferencesContribution);
exports.PreferencesContribution = PreferencesContribution;
//# sourceMappingURL=preferences-contribution.js.map