"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonacoEditorProvider = void 0;
const inversify_1 = require("inversify");
const disposable_1 = require("@theia/core/lib/common/disposable");
const monaco_editor_provider_1 = require("@theia/monaco/lib/browser/monaco-editor-provider");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
let MonacoEditorProvider = class MonacoEditorProvider extends monaco_editor_provider_1.MonacoEditorProvider {
    async doCreateEditor(uri, factory) {
        const editor = await super.doCreateEditor(uri, factory);
        const toDispose = new disposable_1.DisposableCollection();
        toDispose.push(this.installCustomReferencesController(editor));
        toDispose.push(editor.onDispose(() => toDispose.dispose()));
        return editor;
    }
    installCustomReferencesController(editor) {
        const control = editor.getControl();
        const referencesController = control._contributions['editor.contrib.referencesController'];
        const originalToggleWidget = referencesController.toggleWidget;
        const toDispose = new disposable_1.DisposableCollection();
        const toDisposeBeforeToggleWidget = new disposable_1.DisposableCollection();
        referencesController.toggleWidget = (range, modelPromise, peekMode) => {
            toDisposeBeforeToggleWidget.dispose();
            originalToggleWidget.bind(referencesController)(range, modelPromise, peekMode);
            if (referencesController._widget) {
                if ('onDidClose' in referencesController._widget) {
                    toDisposeBeforeToggleWidget.push(referencesController._widget.onDidClose(() => toDisposeBeforeToggleWidget.dispose()));
                }
                const preview = referencesController._widget
                    ._preview;
                if (preview) {
                    toDisposeBeforeToggleWidget.push(preview.onDidChangeModel(() => this.updateReadOnlyState(preview)));
                    this.updateReadOnlyState(preview);
                }
            }
        };
        toDispose.push(disposable_1.Disposable.create(() => toDisposeBeforeToggleWidget.dispose()));
        toDispose.push(disposable_1.Disposable.create(() => (referencesController.toggleWidget = originalToggleWidget)));
        return toDispose;
    }
    updateReadOnlyState(editor) {
        if (!editor) {
            return;
        }
        const model = editor.getModel();
        if (!model) {
            return;
        }
        const readOnly = this.sketchesServiceClient.isReadOnly(model.uri);
        editor.updateOptions({ readOnly });
    }
};
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], MonacoEditorProvider.prototype, "sketchesServiceClient", void 0);
MonacoEditorProvider = __decorate([
    inversify_1.injectable()
], MonacoEditorProvider);
exports.MonacoEditorProvider = MonacoEditorProvider;
//# sourceMappingURL=monaco-editor-provider.js.map