"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationManager = void 0;
const inversify_1 = require("inversify");
const notifications_manager_1 = require("@theia/messages/lib/browser/notifications-manager");
let NotificationManager = class NotificationManager extends notifications_manager_1.NotificationManager {
    async reportProgress(messageId, update, originalMessage, cancellationToken) {
        const notification = this.find(messageId);
        if (!notification) {
            return;
        }
        if (cancellationToken.isCancellationRequested) {
            this.clear(messageId);
        }
        else {
            notification.message =
                originalMessage.text && update.message
                    ? `${originalMessage.text}: ${update.message}`
                    : originalMessage.text || (update === null || update === void 0 ? void 0 : update.message) || notification.message;
            // Unlike in Theia, we allow resetting the progress monitor to NaN to enforce unknown progress.
            const candidate = this.toPlainProgress(update);
            notification.progress =
                typeof candidate === 'number' ? candidate : notification.progress;
        }
        this.fireUpdatedEvent();
    }
    toPlainProgress(update) {
        if (!update.work) {
            return undefined;
        }
        if (Number.isNaN(update.work.done) || Number.isNaN(update.work.total)) {
            return Number.NaN; // This should trigger the unknown monitor.
        }
        return Math.min((update.work.done / update.work.total) * 100, 100);
    }
};
NotificationManager = __decorate([
    inversify_1.injectable()
], NotificationManager);
exports.NotificationManager = NotificationManager;
//# sourceMappingURL=notifications-manager.js.map