"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationComponent = void 0;
const React = require("react");
const notification_component_1 = require("@theia/messages/lib/browser/notification-component");
const common_1 = require("@theia/core/lib/common");
const browser_1 = require("@theia/core/lib/browser");
class NotificationComponent extends notification_component_1.NotificationComponent {
    render() {
        const { messageId, message, type, collapsed, expandable, source, actions } = this.props.notification;
        return (React.createElement("div", { key: messageId, className: "theia-notification-list-item" },
            React.createElement("div", { className: `theia-notification-list-item-content ${collapsed ? 'collapsed' : ''}` },
                React.createElement("div", { className: "theia-notification-list-item-content-main" },
                    React.createElement("div", { className: `theia-notification-icon ${browser_1.codicon(type)} ${type}` }),
                    React.createElement("div", { className: "theia-notification-message" },
                        React.createElement("span", { dangerouslySetInnerHTML: { __html: message }, onClick: this.onMessageClick })),
                    React.createElement("ul", { className: "theia-notification-actions" },
                        expandable && (React.createElement("li", { className: browser_1.codicon('chevron-down') + collapsed
                                ? ' expand'
                                : ' collapse', title: collapsed
                                ? common_1.nls.localize('theia/messages/expand', 'Expand')
                                : common_1.nls.localize('theia/messages/collapse', 'Collapse'), "data-message-id": messageId, onClick: this.onToggleExpansion })),
                        !this.isProgress && (React.createElement("li", { className: browser_1.codicon('close', true), title: common_1.nls.localize('vscode/abstractTree/clear', 'Clear'), "data-message-id": messageId, onClick: this.onClear })))),
                (source || !!actions.length) && (React.createElement("div", { className: "theia-notification-list-item-content-bottom" },
                    React.createElement("div", { className: "theia-notification-source" }, source && React.createElement("span", null, source)),
                    React.createElement("div", { className: "theia-notification-buttons" }, actions &&
                        actions.map((action, index) => (React.createElement("button", { key: messageId + `-action-${index}`, className: "theia-button", "data-message-id": messageId, "data-action": action, onClick: this.onAction }, action))))))),
            this.renderProgressBar()));
    }
    renderProgressBar() {
        if (!this.isProgress) {
            return undefined;
        }
        if (!Number.isNaN(this.props.notification.progress)) {
            return (React.createElement("div", { className: "theia-notification-item-progress" },
                React.createElement("div", { className: "theia-notification-item-progressbar", style: {
                        width: `${this.props.notification.progress}%`,
                    } })));
        }
        return (React.createElement("div", { className: "theia-progress-bar-container" },
            React.createElement("div", { className: "theia-progress-bar" })));
    }
    get isProgress() {
        return typeof this.props.notification.progress === 'number';
    }
}
exports.NotificationComponent = NotificationComponent;
//# sourceMappingURL=notification-component.js.map