"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationCenterComponent = void 0;
const React = require("react");
const notification_component_1 = require("./notification-component");
const notification_center_component_1 = require("@theia/messages/lib/browser/notification-center-component");
const common_1 = require("@theia/core/lib/common");
const browser_1 = require("@theia/core/lib/browser");
const PerfectScrollbar = require('react-perfect-scrollbar');
class NotificationCenterComponent extends notification_center_component_1.NotificationCenterComponent {
    render() {
        const empty = this.state.notifications.length === 0;
        const title = empty
            ? common_1.nls.localize('vscode/notificationsCenter/notificationsEmpty', 'NO NEW NOTIFICATIONS')
            : common_1.nls.localize('vscode/notificationsCenter/notifications', 'NOTIFICATIONS');
        return (React.createElement("div", { className: `theia-notifications-container theia-notification-center ${this.state.visibilityState === 'center' ? 'open' : 'closed'}` },
            React.createElement("div", { className: "theia-notification-center-header" },
                React.createElement("div", { className: "theia-notification-center-header-title" }, title),
                React.createElement("div", { className: "theia-notification-center-header-actions" },
                    React.createElement("ul", { className: "theia-notification-actions" },
                        React.createElement("li", { className: browser_1.codicon('chevron-down', true), title: common_1.nls.localize('vscode/notificationsStatus/hideNotifications', 'Hide Notification Center'), onClick: this.onHide }),
                        React.createElement("li", { className: browser_1.codicon('clear-all', true), title: common_1.nls.localize('vscode/notificationsCommands/clearAllNotifications', 'Clear All'), onClick: this.onClearAll })))),
            React.createElement(PerfectScrollbar, { className: "theia-notification-list-scroll-container" },
                React.createElement("div", { className: "theia-notification-list" }, this.state.notifications.map((notification) => (React.createElement(notification_component_1.NotificationComponent, { key: notification.messageId, notification: notification, manager: this.props.manager })))))));
    }
}
exports.NotificationCenterComponent = NotificationCenterComponent;
//# sourceMappingURL=notification-center-component.js.map