"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugSessionManager = void 0;
const inversify_1 = require("inversify");
const debug_service_1 = require("@theia/debug/lib/common/debug-service");
const debug_session_manager_1 = require("@theia/debug/lib/browser/debug-session-manager");
const common_1 = require("@theia/core/lib/common");
let DebugSessionManager = class DebugSessionManager extends debug_session_manager_1.DebugSessionManager {
    async start(options) {
        return this.progressService.withProgress(common_1.nls.localize('theia/debug/start', 'Start...'), 'debug', async () => {
            try {
                // Only save when dirty. To avoid saving temporary sketches.
                // This is a quick fix for not saving the editor when there are no dirty editors.
                // // https://github.com/bcmi-labs/arduino-editor/pull/172#issuecomment-741831888
                if (this.shell.canSaveAll()) {
                    await this.shell.saveAll();
                }
                await this.fireWillStartDebugSession();
                const resolved = await this.resolveConfiguration(options);
                // preLaunchTask isn't run in case of auto restart as well as postDebugTask
                if (!options.configuration.__restart) {
                    const taskRun = await this.runTask(options.workspaceFolderUri, resolved.configuration.preLaunchTask, true);
                    if (!taskRun) {
                        return undefined;
                    }
                }
                const sessionId = await this.debug.createDebugSession(resolved.configuration);
                return this.doStart(sessionId, resolved);
            }
            catch (e) {
                if (debug_service_1.DebugError.NotFound.is(e)) {
                    this.messageService.error(common_1.nls.localize('theia/debug/typeNotSupported', 'The debug session type "{0}" is not supported.', e.data.type));
                    return undefined;
                }
                this.messageService.error(common_1.nls.localize('theia/debug/startError', 'There was an error starting the debug session, check the logs for more details.'));
                console.error('Error starting the debug session', e);
                throw e;
            }
        });
    }
    async terminateSession(session) {
        if (!session) {
            this.updateCurrentSession(this._currentSession);
            session = this._currentSession;
        }
        // The cortex-debug extension does not respond to close requests
        // So we simply terminate the debug session immediately
        // Alternatively the `super.terminateSession` call will terminate it after 5 seconds without a response
        await this.debug.terminateDebugSession(session.id);
        await super.terminateSession(session);
    }
};
DebugSessionManager = __decorate([
    inversify_1.injectable()
], DebugSessionManager);
exports.DebugSessionManager = DebugSessionManager;
//# sourceMappingURL=debug-session-manager.js.map