"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugHoverWidget = exports.createDebugHoverWidgetContainer = void 0;
const inversify_1 = require("inversify");
const widgets_1 = require("@phosphor/widgets");
const source_tree_1 = require("@theia/core/lib/browser/source-tree");
const disposable_1 = require("@theia/core/lib/common/disposable");
const debug_editor_1 = require("@theia/debug/lib/browser/editor/debug-editor");
const debug_console_items_1 = require("@theia/debug/lib/browser/console/debug-console-items");
const debug_expression_provider_1 = require("@theia/debug/lib/browser/editor/debug-expression-provider");
const debug_hover_source_1 = require("@theia/debug/lib/browser/editor/debug-hover-source");
const debug_hover_widget_1 = require("@theia/debug/lib/browser/editor/debug-hover-widget");
const debug_hover_source_2 = require("./debug-hover-source");
function createDebugHoverWidgetContainer(parent, editor) {
    const child = source_tree_1.SourceTreeWidget.createContainer(parent, {
        virtualized: false,
    });
    child.bind(debug_editor_1.DebugEditor).toConstantValue(editor);
    child.bind(debug_hover_source_1.DebugHoverSource).toSelf();
    child.bind(debug_hover_source_2.DebugHoverSource).toSelf();
    child.rebind(debug_hover_source_1.DebugHoverSource).to(debug_hover_source_2.DebugHoverSource);
    child.unbind(source_tree_1.SourceTreeWidget);
    child.bind(debug_expression_provider_1.DebugExpressionProvider).toSelf();
    child.bind(debug_hover_widget_1.DebugHoverWidget).toSelf();
    child.bind(DebugHoverWidget).toSelf();
    child.rebind(debug_hover_widget_1.DebugHoverWidget).to(DebugHoverWidget);
    return child;
}
exports.createDebugHoverWidgetContainer = createDebugHoverWidgetContainer;
// TODO: remove patch after https://github.com/eclipse-theia/theia/pull/9256/
let DebugHoverWidget = class DebugHoverWidget extends debug_hover_widget_1.DebugHoverWidget {
    async doShow(options = this.options) {
        if (!this.isEditorFrame()) {
            this.hide();
            return;
        }
        if (!options) {
            this.hide();
            return;
        }
        if (this.options && this.options.selection.equalsRange(options.selection)) {
            return;
        }
        if (!this.isAttached) {
            widgets_1.Widget.attach(this, this.contentNode);
        }
        this.options = options;
        const matchingExpression = this.expressionProvider.get(this.editor.getControl().getModel(), options.selection);
        if (!matchingExpression) {
            this.hide();
            return;
        }
        const toFocus = new disposable_1.DisposableCollection();
        if (this.options.focus === true) {
            toFocus.push(this.model.onNodeRefreshed(() => {
                toFocus.dispose();
                this.activate();
            }));
        }
        const expression = await this.hoverSource.evaluate2(matchingExpression);
        if (!expression || !expression.value) {
            toFocus.dispose();
            this.hide();
            return;
        }
        this.contentNode.hidden = false;
        ['number', 'boolean', 'string'].forEach((token) => this.titleNode.classList.remove(token));
        this.domNode.classList.remove('complex-value');
        if (expression.hasElements) {
            this.domNode.classList.add('complex-value');
        }
        else {
            this.contentNode.hidden = true;
            if (expression.type === 'number' ||
                expression.type === 'boolean' ||
                expression.type === 'string') {
                this.titleNode.classList.add(expression.type);
            }
            else if (!isNaN(+expression.value)) {
                this.titleNode.classList.add('number');
            }
            else if (debug_console_items_1.DebugVariable.booleanRegex.test(expression.value)) {
                this.titleNode.classList.add('boolean');
            }
            else if (debug_console_items_1.DebugVariable.stringRegex.test(expression.value)) {
                this.titleNode.classList.add('string');
            }
        }
        // super.show(); // Here we cannot call `super.show()` but have to call `show` on the `Widget` prototype.
        widgets_1.Widget.prototype.show.call(this);
        await new Promise((resolve) => {
            setTimeout(() => window.requestAnimationFrame(() => {
                this.editor.getControl().layoutContentWidget(this);
                resolve();
            }), 0);
        });
    }
};
DebugHoverWidget = __decorate([
    inversify_1.injectable()
], DebugHoverWidget);
exports.DebugHoverWidget = DebugHoverWidget;
//# sourceMappingURL=debug-hover-widget.js.map