"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DebugConfigurationModel = void 0;
const debug_common_1 = require("@theia/debug/lib/common/debug-common");
const debug_configuration_model_1 = require("@theia/debug/lib/browser/debug-configuration-model");
class DebugConfigurationModel extends debug_configuration_model_1.DebugConfigurationModel {
    constructor(workspaceFolderUri, preferences, config, configUri, onConfigDidChange) {
        super(workspaceFolderUri, preferences);
        this.workspaceFolderUri = workspaceFolderUri;
        this.preferences = preferences;
        this.config = config;
        this.configUri = configUri;
        this.onConfigDidChange = onConfigDidChange;
        this.toDispose.push(onConfigDidChange((content) => {
            const { uri, configurations } = content;
            this.configUri = uri;
            this.config.length = 0;
            this.config.push(...configurations);
            this.reconcile();
        }));
        this.reconcile();
    }
    parseConfigurations() {
        return {
            uri: this.configUri,
            configurations: this.config,
        };
    }
}
exports.DebugConfigurationModel = DebugConfigurationModel;
(function (DebugConfigurationModel) {
    function parse(launchConfig) {
        const configurations = [];
        if (launchConfig &&
            typeof launchConfig === 'object' &&
            'configurations' in launchConfig) {
            if (Array.isArray(launchConfig.configurations)) {
                for (const configuration of launchConfig.configurations) {
                    if (debug_common_1.DebugConfiguration.is(configuration)) {
                        configurations.push(configuration);
                    }
                }
            }
        }
        return configurations;
    }
    DebugConfigurationModel.parse = parse;
})(DebugConfigurationModel = exports.DebugConfigurationModel || (exports.DebugConfigurationModel = {}));
//# sourceMappingURL=debug-configuration-model.js.map