"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TabBarRenderer = void 0;
const saveable_1 = require("@theia/core/lib/browser/saveable");
const tab_bars_1 = require("@theia/core/lib/browser/shell/tab-bars");
class TabBarRenderer extends tab_bars_1.TabBarRenderer {
    createTabClass(data) {
        let className = super.createTabClass(data);
        if (!data.title.closable && saveable_1.Saveable.isDirty(data.title.owner)) {
            className += ' p-mod-closable';
        }
        return className;
    }
}
exports.TabBarRenderer = TabBarRenderer;
//# sourceMappingURL=tab-bars.js.map