"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ShellLayoutRestorer = void 0;
const inversify_1 = require("inversify");
const shell_layout_restorer_1 = require("@theia/core/lib/browser/shell/shell-layout-restorer");
let ShellLayoutRestorer = class ShellLayoutRestorer extends shell_layout_restorer_1.ShellLayoutRestorer {
    // Workaround for https://github.com/eclipse-theia/theia/issues/6579.
    async storeLayoutAsync(app) {
        if (this.shouldStoreLayout) {
            try {
                this.logger.info('>>> Storing the layout...');
                const layoutData = app.shell.getLayoutData();
                const serializedLayoutData = this.deflate(layoutData);
                await this.storageService.setData(this.storageKey, serializedLayoutData);
                this.logger.info('<<< The layout has been successfully stored.');
            }
            catch (error) {
                await this.storageService.setData(this.storageKey, undefined);
                this.logger.error('Error during serialization of layout data', error);
            }
        }
    }
    async restoreLayout(app) {
        var _a, _b, _c;
        this.logger.info('>>> Restoring the layout state...');
        const serializedLayoutData = await this.storageService.getData(this.storageKey);
        if (serializedLayoutData === undefined) {
            this.logger.info('<<< Nothing to restore.');
            return false;
        }
        const layoutData = await this.inflate(serializedLayoutData);
        // workaround to remove duplicated tabs
        const filesUri = [];
        if ((_c = (_b = (_a = layoutData) === null || _a === void 0 ? void 0 : _a.mainPanel) === null || _b === void 0 ? void 0 : _b.main) === null || _c === void 0 ? void 0 : _c.widgets) {
            layoutData.mainPanel.main.widgets = layoutData.mainPanel.main.widgets.filter((widget) => {
                const uri = widget.getResourceUri().toString();
                if (filesUri.includes(uri)) {
                    return false;
                }
                filesUri.push(uri);
                return true;
            });
        }
        await app.shell.setLayoutData(layoutData);
        this.logger.info('<<< The layout has been successfully restored.');
        return true;
    }
};
ShellLayoutRestorer = __decorate([
    inversify_1.injectable()
], ShellLayoutRestorer);
exports.ShellLayoutRestorer = ShellLayoutRestorer;
//# sourceMappingURL=shell-layout-restorer.js.map