"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.KeybindingRegistry = void 0;
const inversify_1 = require("inversify");
const command_1 = require("@theia/core/lib/common/command");
const keybinding_1 = require("@theia/core/lib/common/keybinding");
const keybinding_2 = require("@theia/core/lib/browser/keybinding");
let KeybindingRegistry = class KeybindingRegistry extends keybinding_2.KeybindingRegistry {
    unregisterKeybinding(arg) {
        const keymap = this.keymaps[keybinding_2.KeybindingScope.DEFAULT];
        const filter = command_1.Command.is(arg)
            ? ({ command }) => command === arg.id
            : ({ keybinding }) => keybinding_1.Keybinding.is(arg)
                ? keybinding === arg.keybinding
                : keybinding === arg;
        for (const binding of keymap.filter(filter)) {
            const idx = keymap.indexOf(binding);
            if (idx !== -1) {
                keymap.splice(idx, 1);
            }
        }
    }
};
KeybindingRegistry = __decorate([
    inversify_1.injectable()
], KeybindingRegistry);
exports.KeybindingRegistry = KeybindingRegistry;
//# sourceMappingURL=keybindings.js.map