"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.FrontendApplication = void 0;
const inversify_1 = require("inversify");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const command_1 = require("@theia/core/lib/common/command");
const workspace_service_1 = require("@theia/workspace/lib/browser/workspace-service");
const frontend_application_1 = require("@theia/core/lib/browser/frontend-application");
const protocol_1 = require("../../../common/protocol");
const arduino_commands_1 = require("../../arduino-commands");
let FrontendApplication = class FrontendApplication extends frontend_application_1.FrontendApplication {
    async initializeLayout() {
        await super.initializeLayout();
        const roots = await this.workspaceService.roots;
        for (const root of roots) {
            const exists = await this.fileService.exists(root.resource);
            if (exists) {
                this.sketchesService.markAsRecentlyOpened(root.resource.toString()); // no await, will get the notification later and rebuild the menu
                await this.commandService.executeCommand(arduino_commands_1.ArduinoCommands.OPEN_SKETCH_FILES.id, root.resource);
            }
        }
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], FrontendApplication.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(workspace_service_1.WorkspaceService),
    __metadata("design:type", workspace_service_1.WorkspaceService)
], FrontendApplication.prototype, "workspaceService", void 0);
__decorate([
    inversify_1.inject(command_1.CommandService),
    __metadata("design:type", Object)
], FrontendApplication.prototype, "commandService", void 0);
__decorate([
    inversify_1.inject(protocol_1.SketchesService),
    __metadata("design:type", Object)
], FrontendApplication.prototype, "sketchesService", void 0);
FrontendApplication = __decorate([
    inversify_1.injectable()
], FrontendApplication);
exports.FrontendApplication = FrontendApplication;
//# sourceMappingURL=frontend-application.js.map