"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationConnectionStatusContribution = exports.FrontendConnectionStatusService = void 0;
const inversify_1 = require("inversify");
const disposable_1 = require("@theia/core/lib/common/disposable");
const status_bar_1 = require("@theia/core/lib/browser/status-bar/status-bar");
const connection_status_service_1 = require("@theia/core/lib/browser/connection-status-service");
const protocol_1 = require("../../../common/protocol");
const notification_center_1 = require("../../notification-center");
const common_1 = require("@theia/core/lib/common");
let FrontendConnectionStatusService = class FrontendConnectionStatusService extends connection_status_service_1.FrontendConnectionStatusService {
    constructor() {
        super(...arguments);
        this.isRunning = false;
    }
    async init() {
        this.schedulePing();
        try {
            this.isRunning = await this.daemon.isRunning();
        }
        catch (_a) { }
        this.notificationCenter.onDaemonStarted(() => (this.isRunning = true));
        this.notificationCenter.onDaemonStopped(() => (this.isRunning = false));
        this.wsConnectionProvider.onIncomingMessageActivity(() => {
            this.updateStatus(this.isRunning);
            this.schedulePing();
        });
    }
};
__decorate([
    inversify_1.inject(protocol_1.ArduinoDaemon),
    __metadata("design:type", Object)
], FrontendConnectionStatusService.prototype, "daemon", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], FrontendConnectionStatusService.prototype, "notificationCenter", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], FrontendConnectionStatusService.prototype, "init", null);
FrontendConnectionStatusService = __decorate([
    inversify_1.injectable()
], FrontendConnectionStatusService);
exports.FrontendConnectionStatusService = FrontendConnectionStatusService;
let ApplicationConnectionStatusContribution = class ApplicationConnectionStatusContribution extends connection_status_service_1.ApplicationConnectionStatusContribution {
    constructor() {
        super(...arguments);
        this.isRunning = false;
    }
    async init() {
        try {
            this.isRunning = await this.daemon.isRunning();
        }
        catch (_a) { }
        this.notificationCenter.onDaemonStarted(() => (this.isRunning = true));
        this.notificationCenter.onDaemonStopped(() => (this.isRunning = false));
    }
    onStateChange(state) {
        if (!this.isRunning && state === connection_status_service_1.ConnectionStatus.ONLINE) {
            return;
        }
        super.onStateChange(state);
    }
    handleOffline() {
        this.statusBar.setElement('connection-status', {
            alignment: status_bar_1.StatusBarAlignment.LEFT,
            text: this.isRunning
                ? common_1.nls.localize('theia/core/offline', 'Offline')
                : '$(bolt) ' +
                    common_1.nls.localize('theia/core/daemonOffline', 'CLI Daemon Offline'),
            tooltip: this.isRunning
                ? common_1.nls.localize('theia/core/cannotConnectBackend', 'Cannot connect to the backend.')
                : common_1.nls.localize('theia/core/cannotConnectDaemon', 'Cannot connect to the CLI daemon.'),
            priority: 5000,
        });
        this.toDisposeOnOnline.push(disposable_1.Disposable.create(() => this.statusBar.removeElement('connection-status')));
        document.body.classList.add('theia-mod-offline');
        this.toDisposeOnOnline.push(disposable_1.Disposable.create(() => document.body.classList.remove('theia-mod-offline')));
    }
};
__decorate([
    inversify_1.inject(protocol_1.ArduinoDaemon),
    __metadata("design:type", Object)
], ApplicationConnectionStatusContribution.prototype, "daemon", void 0);
__decorate([
    inversify_1.inject(notification_center_1.NotificationCenter),
    __metadata("design:type", notification_center_1.NotificationCenter)
], ApplicationConnectionStatusContribution.prototype, "notificationCenter", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ApplicationConnectionStatusContribution.prototype, "init", null);
ApplicationConnectionStatusContribution = __decorate([
    inversify_1.injectable()
], ApplicationConnectionStatusContribution);
exports.ApplicationConnectionStatusContribution = ApplicationConnectionStatusContribution;
//# sourceMappingURL=connection-status-service.js.map