"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationShell = void 0;
const inversify_1 = require("inversify");
const browser_1 = require("@theia/editor/lib/browser");
const command_1 = require("@theia/core/lib/common/command");
const message_service_1 = require("@theia/core/lib/common/message-service");
const output_widget_1 = require("@theia/output/lib/browser/output-widget");
const connection_status_service_1 = require("@theia/core/lib/browser/connection-status-service");
const browser_2 = require("@theia/core/lib/browser");
const protocol_1 = require("../../../common/protocol");
const save_as_sketch_1 = require("../../contributions/save-as-sketch");
const sketches_service_client_impl_1 = require("../../../common/protocol/sketches-service-client-impl");
const common_1 = require("@theia/core/lib/common");
let ApplicationShell = class ApplicationShell extends browser_2.ApplicationShell {
    track(widget) {
        super.track(widget);
        if (widget instanceof output_widget_1.OutputWidget) {
            widget.title.closable = false; // TODO: https://arduino.slack.com/archives/C01698YT7S4/p1598011990133700
        }
        if (widget instanceof browser_1.EditorWidget) {
            // Make the editor un-closeable asynchronously.
            this.sketchesServiceClient.currentSketch().then((sketch) => {
                if (sketch) {
                    if (protocol_1.Sketch.isInSketch(widget.editor.uri, sketch)) {
                        widget.title.closable = false;
                    }
                }
            });
        }
    }
    async addWidget(widget, options = {}) {
        // By default, Theia open a widget **next** to the currently active in the target area.
        // Instead of this logic, we want to open the new widget after the last of the target area.
        if (!widget.id) {
            console.error('Widgets added to the application shell must have a unique id property.');
            return;
        }
        let ref = options.ref;
        const area = options.area || 'main';
        if (!ref && (area === 'main' || area === 'bottom')) {
            const tabBar = this.getTabBarFor(area);
            if (tabBar) {
                const last = tabBar.titles[tabBar.titles.length - 1];
                if (last) {
                    ref = last.owner;
                }
            }
        }
        return super.addWidget(widget, Object.assign(Object.assign({}, options), { ref }));
    }
    // Avoid hiding top panel as we use it for arduino toolbar
    createTopPanel() {
        const topPanel = super.createTopPanel();
        topPanel.show();
        return topPanel;
    }
    async saveAll() {
        if (this.connectionStatusService.currentStatus === connection_status_service_1.ConnectionStatus.OFFLINE) {
            this.messageService.error(common_1.nls.localize('theia/core/couldNotSave', 'Could not save the sketch. Please copy your unsaved work into your favorite text editor, and restart the IDE.'));
            return; // Theia does not reject on failed save: https://github.com/eclipse-theia/theia/pull/8803
        }
        await super.saveAll();
        const options = { execOnlyIfTemp: true, openAfterMove: true };
        await this.commandService.executeCommand(save_as_sketch_1.SaveAsSketch.Commands.SAVE_AS_SKETCH.id, options);
    }
};
__decorate([
    inversify_1.inject(command_1.CommandService),
    __metadata("design:type", Object)
], ApplicationShell.prototype, "commandService", void 0);
__decorate([
    inversify_1.inject(message_service_1.MessageService),
    __metadata("design:type", message_service_1.MessageService)
], ApplicationShell.prototype, "messageService", void 0);
__decorate([
    inversify_1.inject(sketches_service_client_impl_1.SketchesServiceClientImpl),
    __metadata("design:type", sketches_service_client_impl_1.SketchesServiceClientImpl)
], ApplicationShell.prototype, "sketchesServiceClient", void 0);
__decorate([
    inversify_1.inject(connection_status_service_1.ConnectionStatusService),
    __metadata("design:type", Object)
], ApplicationShell.prototype, "connectionStatusService", void 0);
ApplicationShell = __decorate([
    inversify_1.injectable()
], ApplicationShell);
exports.ApplicationShell = ApplicationShell;
//# sourceMappingURL=application-shell.js.map