"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialServiceClientImpl = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
let SerialServiceClientImpl = class SerialServiceClientImpl {
    constructor() {
        this.onErrorEmitter = new event_1.Emitter();
        this.onError = this.onErrorEmitter.event;
        this.onWebSocketChangedEmitter = new event_1.Emitter();
        this.onWebSocketChanged = this.onWebSocketChangedEmitter.event;
        this.onBaudRateChangedEmitter = new event_1.Emitter();
        this.onBaudRateChanged = this.onBaudRateChangedEmitter.event;
        this.onLineEndingChangedEmitter = new event_1.Emitter();
        this.onLineEndingChanged = this.onLineEndingChangedEmitter.event;
        this.onInterpolateChangedEmitter = new event_1.Emitter();
        this.onInterpolateChanged = this.onInterpolateChangedEmitter.event;
    }
    notifyError(error) {
        this.onErrorEmitter.fire(error);
    }
    notifyWebSocketChanged(message) {
        this.onWebSocketChangedEmitter.fire(message);
    }
    notifyBaudRateChanged(message) {
        this.onBaudRateChangedEmitter.fire(message);
    }
    notifyLineEndingChanged(message) {
        this.onLineEndingChangedEmitter.fire(message);
    }
    notifyInterpolateChanged(message) {
        this.onInterpolateChangedEmitter.fire(message);
    }
};
SerialServiceClientImpl = __decorate([
    inversify_1.injectable()
], SerialServiceClientImpl);
exports.SerialServiceClientImpl = SerialServiceClientImpl;
//# sourceMappingURL=serial-service-client-impl.js.map