"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var SerialModel_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialModel = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const protocol_1 = require("../../common/protocol");
const browser_1 = require("@theia/core/lib/browser");
const boards_service_provider_1 = require("../boards/boards-service-provider");
let SerialModel = SerialModel_1 = class SerialModel {
    constructor() {
        this._autoscroll = true;
        this._timestamp = false;
        this._baudRate = protocol_1.SerialConfig.BaudRate.DEFAULT;
        this._lineEnding = SerialModel_1.EOL.DEFAULT;
        this._interpolate = false;
        this.onChangeEmitter = new event_1.Emitter();
    }
    onStart() {
        this.localStorageService
            .getData(SerialModel_1.STORAGE_ID)
            .then((state) => {
            if (state) {
                this.restoreState(state);
            }
        });
    }
    get onChange() {
        return this.onChangeEmitter.event;
    }
    get autoscroll() {
        return this._autoscroll;
    }
    toggleAutoscroll() {
        this._autoscroll = !this._autoscroll;
        this.storeState();
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'autoscroll',
            value: this._autoscroll,
        }));
    }
    get timestamp() {
        return this._timestamp;
    }
    toggleTimestamp() {
        this._timestamp = !this._timestamp;
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'timestamp',
            value: this._timestamp,
        }));
    }
    get baudRate() {
        return this._baudRate;
    }
    set baudRate(baudRate) {
        this._baudRate = baudRate;
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'baudRate',
            value: this._baudRate,
        }));
    }
    get lineEnding() {
        return this._lineEnding;
    }
    set lineEnding(lineEnding) {
        this._lineEnding = lineEnding;
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'lineEnding',
            value: this._lineEnding,
        }));
    }
    get interpolate() {
        return this._interpolate;
    }
    set interpolate(i) {
        this._interpolate = i;
        this.storeState().then(() => this.onChangeEmitter.fire({
            property: 'interpolate',
            value: this._interpolate,
        }));
    }
    restoreState(state) {
        this._autoscroll = state.autoscroll;
        this._timestamp = state.timestamp;
        this._baudRate = state.baudRate;
        this._lineEnding = state.lineEnding;
        this._interpolate = state.interpolate;
    }
    async storeState() {
        return this.localStorageService.setData(SerialModel_1.STORAGE_ID, {
            autoscroll: this._autoscroll,
            timestamp: this._timestamp,
            baudRate: this._baudRate,
            lineEnding: this._lineEnding,
            interpolate: this._interpolate,
        });
    }
};
SerialModel.STORAGE_ID = 'arduino-serial-model';
__decorate([
    inversify_1.inject(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], SerialModel.prototype, "localStorageService", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], SerialModel.prototype, "boardsServiceClient", void 0);
SerialModel = SerialModel_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], SerialModel);
exports.SerialModel = SerialModel;
(function (SerialModel) {
    let EOL;
    (function (EOL) {
        EOL.DEFAULT = '\n';
    })(EOL = SerialModel.EOL || (SerialModel.EOL = {}));
})(SerialModel = exports.SerialModel || (exports.SerialModel = {}));
exports.SerialModel = SerialModel;
//# sourceMappingURL=serial-model.js.map