"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Serial = exports.SerialConnectionManager = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const message_service_1 = require("@theia/core/lib/common/message-service");
const serial_service_1 = require("../../common/protocol/serial-service");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const boards_service_1 = require("../../common/protocol/boards-service");
const serial_model_1 = require("./serial-model");
const theming_1 = require("@theia/core/lib/browser/theming");
const protocol_1 = require("../../common/protocol");
const nls_1 = require("@theia/core/lib/common/nls");
let SerialConnectionManager = class SerialConnectionManager {
    constructor(serialModel, serialService, serialServiceClient, boardsService, boardsServiceProvider, messageService, themeService, core, boardsServiceClientImpl) {
        this.serialModel = serialModel;
        this.serialService = serialService;
        this.serialServiceClient = serialServiceClient;
        this.boardsService = boardsService;
        this.boardsServiceProvider = boardsServiceProvider;
        this.messageService = messageService;
        this.themeService = themeService;
        this.core = core;
        this.boardsServiceClientImpl = boardsServiceClientImpl;
        this.config = {
            board: undefined,
            port: undefined,
            baudRate: undefined,
        };
        this.onConnectionChangedEmitter = new event_1.Emitter();
        /**
         * This emitter forwards all read events **if** the connection is established.
         */
        this.onReadEmitter = new event_1.Emitter();
        /**
         * Array for storing previous serial errors received from the server, and based on the number of elements in this array,
         * we adjust the reconnection delay.
         * Super naive way: we wait `array.length * 1000` ms. Once we hit 10 errors, we do not try to reconnect and clean the array.
         */
        this.serialErrors = [];
        this.serialServiceClient.onWebSocketChanged(this.handleWebSocketChanged.bind(this));
        this.serialServiceClient.onBaudRateChanged((baudRate) => {
            if (this.serialModel.baudRate !== baudRate) {
                this.serialModel.baudRate = baudRate;
            }
        });
        this.serialServiceClient.onLineEndingChanged((lineending) => {
            if (this.serialModel.lineEnding !== lineending) {
                this.serialModel.lineEnding = lineending;
            }
        });
        this.serialServiceClient.onInterpolateChanged((interpolate) => {
            if (this.serialModel.interpolate !== interpolate) {
                this.serialModel.interpolate = interpolate;
            }
        });
        this.serialServiceClient.onError(this.handleError.bind(this));
        this.boardsServiceProvider.onBoardsConfigChanged(this.handleBoardConfigChange.bind(this));
        // Handles the `baudRate` changes by reconnecting if required.
        this.serialModel.onChange(async ({ property }) => {
            if (property === 'baudRate' &&
                (await this.serialService.isSerialPortOpen())) {
                const { boardsConfig } = this.boardsServiceProvider;
                this.handleBoardConfigChange(boardsConfig);
            }
            // update the current values in the backend and propagate to websocket clients
            this.serialService.updateWsConfigParam(Object.assign(Object.assign({}, (property === 'lineEnding' && {
                currentLineEnding: this.serialModel.lineEnding,
            })), (property === 'interpolate' && {
                interpolate: this.serialModel.interpolate,
            })));
        });
        this.themeService.onDidColorThemeChange((theme) => {
            this.serialService.updateWsConfigParam({
                darkTheme: theme.newTheme.type === 'dark',
            });
        });
    }
    /**
     * Updated the config in the BE passing only the properties that has changed.
     * BE will create a new connection if needed.
     *
     * @param newConfig the porperties of the config that has changed
     */
    async setConfig(newConfig) {
        var _a;
        let configHasChanged = false;
        Object.keys(this.config).forEach((key) => {
            if (newConfig[key] !== this.config[key]) {
                configHasChanged = true;
                this.config = Object.assign(Object.assign({}, this.config), { [key]: newConfig[key] });
            }
        });
        if (configHasChanged) {
            this.serialService.updateWsConfigParam({
                currentBaudrate: this.config.baudRate,
                serialPort: (_a = this.config.port) === null || _a === void 0 ? void 0 : _a.address,
            });
            if (isSerialConfig(this.config)) {
                this.serialService.setSerialConfig(this.config);
            }
        }
    }
    getConfig() {
        return this.config;
    }
    getWsPort() {
        return this.wsPort;
    }
    handleWebSocketChanged(wsPort) {
        this.wsPort = wsPort;
    }
    get serialConfig() {
        return isSerialConfig(this.config)
            ? this.config
            : undefined;
    }
    async isBESerialConnected() {
        return await this.serialService.isSerialPortOpen();
    }
    openWSToBE() {
        if (!isSerialConfig(this.config)) {
            this.messageService.error(`Please select a board and a port to open the serial connection.`);
        }
        if (!this.webSocket && this.wsPort) {
            try {
                this.webSocket = new WebSocket(`ws://localhost:${this.wsPort}`);
                this.webSocket.onmessage = (res) => {
                    const messages = JSON.parse(res.data);
                    this.onReadEmitter.fire({ messages });
                };
            }
            catch (_a) {
                this.messageService.error(`Unable to connect to websocket`);
            }
        }
    }
    closeWStoBE() {
        if (this.webSocket) {
            try {
                this.webSocket.close();
                this.webSocket = undefined;
            }
            catch (_a) {
                this.messageService.error(`Unable to close websocket`);
            }
        }
    }
    /**
     * Handles error on the SerialServiceClient and try to reconnect, eventually
     */
    async handleError(error) {
        if (!(await this.serialService.isSerialPortOpen()))
            return;
        const { code, config } = error;
        const { board, port } = config;
        const options = { timeout: 3000 };
        switch (code) {
            case serial_service_1.SerialError.ErrorCodes.CLIENT_CANCEL: {
                console.debug(`Serial connection was canceled by client: ${Serial.Config.toString(this.config)}.`);
                break;
            }
            case serial_service_1.SerialError.ErrorCodes.DEVICE_BUSY: {
                this.messageService.warn(nls_1.nls.localize('arduino/serial/connectionBusy', 'Connection failed. Serial port is busy: {0}', port.address), options);
                this.serialErrors.push(error);
                break;
            }
            case serial_service_1.SerialError.ErrorCodes.DEVICE_NOT_CONFIGURED: {
                this.messageService.info(nls_1.nls.localize('arduino/serial/disconnected', 'Disconnected {0} from {1}.', boards_service_1.Board.toString(board, {
                    useFqbn: false,
                }), port.address), options);
                break;
            }
            case undefined: {
                this.messageService.error(nls_1.nls.localize('arduino/serial/unexpectedError', 'Unexpected error. Reconnecting {0} on port {1}.', boards_service_1.Board.toString(board), port.address), options);
                console.error(JSON.stringify(error));
                break;
            }
        }
        if ((await this.serialService.clientsAttached()) > 0) {
            if (this.serialErrors.length >= 10) {
                this.messageService.warn(nls_1.nls.localize('arduino/serial/failedReconnect', 'Failed to reconnect {0} to serial port after 10 consecutive attempts. The {1} serial port is busy.', boards_service_1.Board.toString(board, {
                    useFqbn: false,
                }), port.address));
                this.serialErrors.length = 0;
            }
            else {
                const attempts = this.serialErrors.length || 1;
                if (this.reconnectTimeout !== undefined) {
                    // Clear the previous timer.
                    window.clearTimeout(this.reconnectTimeout);
                }
                const timeout = attempts * 1000;
                this.messageService.warn(nls_1.nls.localize('arduino/serial/reconnect', 'Reconnecting {0} to {1} in {2} seconds...', boards_service_1.Board.toString(board, {
                    useFqbn: false,
                }), port.address, attempts.toString()));
                this.reconnectTimeout = window.setTimeout(() => this.reconnectAfterUpload(), timeout);
            }
        }
    }
    async reconnectAfterUpload() {
        try {
            if (isSerialConfig(this.config)) {
                await this.boardsServiceClientImpl.waitUntilAvailable(Object.assign(this.config.board, { port: this.config.port }), 10000);
                this.serialService.connectSerialIfRequired();
            }
        }
        catch (waitError) {
            this.messageService.error(nls_1.nls.localize('arduino/sketch/couldNotConnectToSerial', 'Could not reconnect to serial port. {0}', waitError.toString()));
        }
    }
    /**
     * Sends the data to the connected serial port.
     * The desired EOL is appended to `data`, you do not have to add it.
     * It is a NOOP if connected.
     */
    async send(data) {
        if (!(await this.serialService.isSerialPortOpen())) {
            return serial_service_1.Status.NOT_CONNECTED;
        }
        return new Promise((resolve) => {
            this.serialService
                .sendMessageToSerial(data + this.serialModel.lineEnding)
                .then(() => resolve(serial_service_1.Status.OK));
        });
    }
    get onConnectionChanged() {
        return this.onConnectionChangedEmitter.event;
    }
    get onRead() {
        return this.onReadEmitter.event;
    }
    async handleBoardConfigChange(boardsConfig) {
        const { selectedBoard: board, selectedPort: port } = boardsConfig;
        const { baudRate } = this.serialModel;
        const newConfig = { board, port, baudRate };
        this.setConfig(newConfig);
    }
};
SerialConnectionManager = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(serial_model_1.SerialModel)),
    __param(1, inversify_1.inject(serial_service_1.SerialService)),
    __param(2, inversify_1.inject(serial_service_1.SerialServiceClient)),
    __param(3, inversify_1.inject(boards_service_1.BoardsService)),
    __param(4, inversify_1.inject(boards_service_provider_1.BoardsServiceProvider)),
    __param(5, inversify_1.inject(message_service_1.MessageService)),
    __param(6, inversify_1.inject(theming_1.ThemeService)),
    __param(7, inversify_1.inject(protocol_1.CoreService)),
    __param(8, inversify_1.inject(boards_service_provider_1.BoardsServiceProvider)),
    __metadata("design:paramtypes", [serial_model_1.SerialModel, Object, Object, Object, boards_service_provider_1.BoardsServiceProvider,
        message_service_1.MessageService,
        theming_1.ThemeService, Object, boards_service_provider_1.BoardsServiceProvider])
], SerialConnectionManager);
exports.SerialConnectionManager = SerialConnectionManager;
var Serial;
(function (Serial) {
    let Config;
    (function (Config) {
        function toString(config) {
            if (!isSerialConfig(config))
                return '';
            const { board, port } = config;
            return `${boards_service_1.Board.toString(board)} ${port.address}`;
        }
        Config.toString = toString;
    })(Config = Serial.Config || (Serial.Config = {}));
})(Serial = exports.Serial || (exports.Serial = {}));
function isSerialConfig(config) {
    return !!config.board && !!config.baudRate && !!config.port;
}
//# sourceMappingURL=serial-connection-manager.js.map