"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlotterFrontendContribution = exports.SerialPlotterContribution = void 0;
const theming_1 = require("@theia/core/lib/browser/theming");
const inversify_1 = require("inversify");
const serial_model_1 = require("../serial-model");
const arduino_menus_1 = require("../../menu/arduino-menus");
const contribution_1 = require("../../contributions/contribution");
const browser_1 = require("@theia/core/lib/browser");
const electron_1 = require("@theia/electron/shared/electron");
const protocol_1 = require("../../../common/protocol");
const serial_connection_manager_1 = require("../serial-connection-manager");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const queryString = require('query-string');
var SerialPlotterContribution;
(function (SerialPlotterContribution) {
    let Commands;
    (function (Commands) {
        Commands.OPEN = {
            id: 'serial-plotter-open',
            label: 'Serial Plotter',
            category: 'Arduino',
        };
    })(Commands = SerialPlotterContribution.Commands || (SerialPlotterContribution.Commands = {}));
})(SerialPlotterContribution = exports.SerialPlotterContribution || (exports.SerialPlotterContribution = {}));
let PlotterFrontendContribution = class PlotterFrontendContribution extends contribution_1.Contribution {
    onStart(app) {
        this.url = new browser_1.Endpoint({ path: '/plotter' }).getRestUrl().toString();
        electron_1.ipcRenderer.on('CLOSE_CHILD_WINDOW', async () => {
            if (!!this.window) {
                this.window = null;
            }
        });
        return super.onStart(app);
    }
    registerCommands(registry) {
        registry.registerCommand(SerialPlotterContribution.Commands.OPEN, {
            execute: this.connect.bind(this),
        });
    }
    registerMenus(menus) {
        menus.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
            commandId: SerialPlotterContribution.Commands.OPEN.id,
            label: SerialPlotterContribution.Commands.OPEN.label,
            order: '7',
        });
    }
    async connect() {
        if (!!this.window) {
            this.window.focus();
            return;
        }
        const wsPort = this.serialConnection.getWsPort();
        if (wsPort) {
            this.open(wsPort);
        }
        else {
            this.messageService.error(`Couldn't open serial plotter`);
        }
    }
    async open(wsPort) {
        var _a;
        const initConfig = {
            baudrates: protocol_1.SerialConfig.BaudRates.map((b) => b),
            currentBaudrate: this.model.baudRate,
            currentLineEnding: this.model.lineEnding,
            darkTheme: this.themeService.getCurrentTheme().type === 'dark',
            wsPort,
            interpolate: this.model.interpolate,
            connected: await this.serialConnection.isBESerialConnected(),
            serialPort: (_a = this.boardsServiceProvider.boardsConfig.selectedPort) === null || _a === void 0 ? void 0 : _a.address,
        };
        const urlWithParams = queryString.stringifyUrl({
            url: this.url,
            query: initConfig,
        }, { arrayFormat: 'comma' });
        this.window = window.open(urlWithParams, 'serialPlotter');
    }
};
__decorate([
    inversify_1.inject(serial_model_1.SerialModel),
    __metadata("design:type", serial_model_1.SerialModel)
], PlotterFrontendContribution.prototype, "model", void 0);
__decorate([
    inversify_1.inject(theming_1.ThemeService),
    __metadata("design:type", theming_1.ThemeService)
], PlotterFrontendContribution.prototype, "themeService", void 0);
__decorate([
    inversify_1.inject(serial_connection_manager_1.SerialConnectionManager),
    __metadata("design:type", serial_connection_manager_1.SerialConnectionManager)
], PlotterFrontendContribution.prototype, "serialConnection", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], PlotterFrontendContribution.prototype, "boardsServiceProvider", void 0);
PlotterFrontendContribution = __decorate([
    inversify_1.injectable()
], PlotterFrontendContribution);
exports.PlotterFrontendContribution = PlotterFrontendContribution;
//# sourceMappingURL=plotter-frontend-contribution.js.map