"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SerialMonitorOutput = void 0;
const React = require("react");
const disposable_1 = require("@theia/core/lib/common/disposable");
const react_window_1 = require("react-window");
const dateFormat = require("dateformat");
const monitor_utils_1 = require("./monitor-utils");
class SerialMonitorOutput extends React.Component {
    constructor(props) {
        super(props);
        /**
         * Do not touch it. It is used to be able to "follow" the serial monitor log.
         */
        this.toDisposeBeforeUnmount = new disposable_1.DisposableCollection();
        this.scrollToBottom = (() => {
            if (this.listRef.current && this.props.serialModel.autoscroll) {
                this.listRef.current.scrollToItem(this.state.lines.length, 'end');
            }
        }).bind(this);
        this.listRef = React.createRef();
        this.state = {
            lines: [],
            timestamp: this.props.serialModel.timestamp,
            charCount: 0,
        };
    }
    render() {
        return (React.createElement(react_window_1.FixedSizeList, { className: "serial-monitor-messages", height: this.props.height, itemData: {
                lines: this.state.lines,
                timestamp: this.state.timestamp,
            }, itemCount: this.state.lines.length, itemSize: 18, width: '100%', style: { whiteSpace: 'nowrap' }, ref: this.listRef }, Row));
    }
    shouldComponentUpdate() {
        return true;
    }
    componentDidMount() {
        this.scrollToBottom();
        this.toDisposeBeforeUnmount.pushAll([
            this.props.serialConnection.onRead(({ messages }) => {
                const [newLines, totalCharCount] = monitor_utils_1.messagesToLines(messages, this.state.lines, this.state.charCount);
                const [lines, charCount] = monitor_utils_1.truncateLines(newLines, totalCharCount);
                this.setState({
                    lines,
                    charCount,
                });
                this.scrollToBottom();
            }),
            this.props.clearConsoleEvent(() => this.setState({ lines: [], charCount: 0 })),
            this.props.serialModel.onChange(({ property }) => {
                if (property === 'timestamp') {
                    const { timestamp } = this.props.serialModel;
                    this.setState({ timestamp });
                }
                if (property === 'autoscroll') {
                    this.scrollToBottom();
                }
            }),
        ]);
    }
    componentWillUnmount() {
        // TODO: "Your preferred browser's local storage is almost full." Discard `content` before saving layout?
        this.toDisposeBeforeUnmount.dispose();
    }
}
exports.SerialMonitorOutput = SerialMonitorOutput;
const _Row = ({ index, style, data, }) => {
    const timestamp = (data.timestamp &&
        `${dateFormat(data.lines[index].timestamp, 'H:M:ss.l')} -> `) ||
        '';
    return ((data.lines[index].lineLen && (React.createElement("div", { style: style },
        timestamp,
        data.lines[index].message))) ||
        null);
};
const Row = React.memo(_Row, react_window_1.areEqual);
(function (SerialMonitorOutput) {
    SerialMonitorOutput.MAX_CHARACTERS = 1000000;
})(SerialMonitorOutput = exports.SerialMonitorOutput || (exports.SerialMonitorOutput = {}));
//# sourceMappingURL=serial-monitor-send-output.js.map