"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var MonitorWidget_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MonitorWidget = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const disposable_1 = require("@theia/core/lib/common/disposable");
const widgets_1 = require("@theia/core/lib/browser/widgets");
const arduino_select_1 = require("../../widgets/arduino-select");
const serial_model_1 = require("../serial-model");
const serial_connection_manager_1 = require("../serial-connection-manager");
const serial_monitor_send_input_1 = require("./serial-monitor-send-input");
const serial_monitor_send_output_1 = require("./serial-monitor-send-output");
const boards_service_provider_1 = require("../../boards/boards-service-provider");
const common_1 = require("@theia/core/lib/common");
let MonitorWidget = MonitorWidget_1 = class MonitorWidget extends widgets_1.ReactWidget {
    constructor() {
        super();
        /**
         * Guard against re-rendering the view after the close was requested.
         * See: https://github.com/eclipse-theia/theia/issues/6704
         */
        this.closing = false;
        this.clearOutputEmitter = new event_1.Emitter();
        this.onFocusResolved = (element) => {
            if (this.closing || !this.isAttached) {
                return;
            }
            this.focusNode = element;
            requestAnimationFrame(() => widgets_1.MessageLoop.sendMessage(this, widgets_1.Widget.Msg.ActivateRequest));
        };
        this.onSend = (value) => this.doSend(value);
        this.onChangeLineEnding = (option) => {
            this.serialModel.lineEnding = option.value;
        };
        this.onChangeBaudRate = (option) => {
            this.serialModel.baudRate = option.value;
        };
        this.id = MonitorWidget_1.ID;
        this.title.label = MonitorWidget_1.LABEL;
        this.title.iconClass = 'monitor-tab-icon';
        this.title.closable = true;
        this.scrollOptions = undefined;
        this.toDispose.push(this.clearOutputEmitter);
        this.toDispose.push(disposable_1.Disposable.create(() => this.serialConnection.closeWStoBE()));
    }
    init() {
        this.update();
        this.toDispose.push(this.serialConnection.onConnectionChanged(() => this.clearConsole()));
        this.toDispose.push(this.serialModel.onChange(() => this.update()));
    }
    clearConsole() {
        this.clearOutputEmitter.fire(undefined);
        this.update();
    }
    dispose() {
        super.dispose();
    }
    onAfterAttach(msg) {
        super.onAfterAttach(msg);
        this.serialConnection.openWSToBE();
    }
    onCloseRequest(msg) {
        this.closing = true;
        super.onCloseRequest(msg);
    }
    onUpdateRequest(msg) {
        // TODO: `this.isAttached`
        // See: https://github.com/eclipse-theia/theia/issues/6704#issuecomment-562574713
        if (!this.closing && this.isAttached) {
            super.onUpdateRequest(msg);
        }
    }
    onResize(msg) {
        super.onResize(msg);
        this.widgetHeight = msg.height;
        this.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        (this.focusNode || this.node).focus();
    }
    get lineEndings() {
        return [
            {
                label: common_1.nls.localize('arduino/serial/noLineEndings', 'No Line Ending'),
                value: '',
            },
            {
                label: common_1.nls.localize('arduino/serial/newLine', 'New Line'),
                value: '\n',
            },
            {
                label: common_1.nls.localize('arduino/serial/carriageReturn', 'Carriage Return'),
                value: '\r',
            },
            {
                label: common_1.nls.localize('arduino/serial/newLineCarriageReturn', 'Both NL & CR'),
                value: '\r\n',
            },
        ];
    }
    get baudRates() {
        const baudRates = [
            300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200,
        ];
        return baudRates.map((baudRate) => ({
            label: baudRate + ' baud',
            value: baudRate,
        }));
    }
    render() {
        const { baudRates, lineEndings } = this;
        const lineEnding = lineEndings.find((item) => item.value === this.serialModel.lineEnding) ||
            lineEndings[1]; // Defaults to `\n`.
        const baudRate = baudRates.find((item) => item.value === this.serialModel.baudRate) ||
            baudRates[4]; // Defaults to `9600`.
        return (React.createElement("div", { className: "serial-monitor" },
            React.createElement("div", { className: "head" },
                React.createElement("div", { className: "send" },
                    React.createElement(serial_monitor_send_input_1.SerialMonitorSendInput, { serialConnection: this.serialConnection, resolveFocus: this.onFocusResolved, onSend: this.onSend })),
                React.createElement("div", { className: "config" },
                    React.createElement("div", { className: "select" },
                        React.createElement(arduino_select_1.ArduinoSelect, { maxMenuHeight: this.widgetHeight - 40, options: lineEndings, value: lineEnding, onChange: this.onChangeLineEnding })),
                    React.createElement("div", { className: "select" },
                        React.createElement(arduino_select_1.ArduinoSelect, { className: "select", maxMenuHeight: this.widgetHeight - 40, options: baudRates, value: baudRate, onChange: this.onChangeBaudRate })))),
            React.createElement("div", { className: "body" },
                React.createElement(serial_monitor_send_output_1.SerialMonitorOutput, { serialModel: this.serialModel, serialConnection: this.serialConnection, clearConsoleEvent: this.clearOutputEmitter.event, height: Math.floor(this.widgetHeight - 50) }))));
    }
    async doSend(value) {
        this.serialConnection.send(value);
    }
};
MonitorWidget.LABEL = common_1.nls.localize('arduino/common/serialMonitor', 'Serial Monitor');
MonitorWidget.ID = 'serial-monitor';
__decorate([
    inversify_1.inject(serial_model_1.SerialModel),
    __metadata("design:type", serial_model_1.SerialModel)
], MonitorWidget.prototype, "serialModel", void 0);
__decorate([
    inversify_1.inject(serial_connection_manager_1.SerialConnectionManager),
    __metadata("design:type", serial_connection_manager_1.SerialConnectionManager)
], MonitorWidget.prototype, "serialConnection", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], MonitorWidget.prototype, "boardsServiceProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], MonitorWidget.prototype, "init", null);
MonitorWidget = MonitorWidget_1 = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], MonitorWidget);
exports.MonitorWidget = MonitorWidget;
//# sourceMappingURL=monitor-widget.js.map