"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationCenter = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const disposable_1 = require("@theia/core/lib/common/disposable");
const notification_service_1 = require("../common/protocol/notification-service");
let NotificationCenter = class NotificationCenter {
    constructor() {
        this.indexUpdatedEmitter = new event_1.Emitter();
        this.daemonStartedEmitter = new event_1.Emitter();
        this.daemonStoppedEmitter = new event_1.Emitter();
        this.configChangedEmitter = new event_1.Emitter();
        this.platformInstalledEmitter = new event_1.Emitter();
        this.platformUninstalledEmitter = new event_1.Emitter();
        this.libraryInstalledEmitter = new event_1.Emitter();
        this.libraryUninstalledEmitter = new event_1.Emitter();
        this.attachedBoardsChangedEmitter = new event_1.Emitter();
        this.recentSketchesChangedEmitter = new event_1.Emitter();
        this.toDispose = new disposable_1.DisposableCollection(this.indexUpdatedEmitter, this.daemonStartedEmitter, this.daemonStoppedEmitter, this.configChangedEmitter, this.platformInstalledEmitter, this.platformUninstalledEmitter, this.libraryInstalledEmitter, this.libraryUninstalledEmitter, this.attachedBoardsChangedEmitter);
        this.onIndexUpdated = this.indexUpdatedEmitter.event;
        this.onDaemonStarted = this.daemonStartedEmitter.event;
        this.onDaemonStopped = this.daemonStoppedEmitter.event;
        this.onConfigChanged = this.configChangedEmitter.event;
        this.onPlatformInstalled = this.platformInstalledEmitter.event;
        this.onPlatformUninstalled = this.platformUninstalledEmitter.event;
        this.onLibraryInstalled = this.libraryInstalledEmitter.event;
        this.onLibraryUninstalled = this.libraryUninstalledEmitter.event;
        this.onAttachedBoardsChanged = this.attachedBoardsChangedEmitter.event;
        this.onRecentSketchesChanged = this.recentSketchesChangedEmitter.event;
    }
    init() {
        this.server.setClient(this);
    }
    onStop() {
        this.toDispose.dispose();
    }
    notifyIndexUpdated() {
        this.indexUpdatedEmitter.fire();
    }
    notifyDaemonStarted() {
        this.daemonStartedEmitter.fire();
    }
    notifyDaemonStopped() {
        this.daemonStoppedEmitter.fire();
    }
    notifyConfigChanged(event) {
        this.configChangedEmitter.fire(event);
    }
    notifyPlatformInstalled(event) {
        this.platformInstalledEmitter.fire(event);
    }
    notifyPlatformUninstalled(event) {
        this.platformUninstalledEmitter.fire(event);
    }
    notifyLibraryInstalled(event) {
        this.libraryInstalledEmitter.fire(event);
    }
    notifyLibraryUninstalled(event) {
        this.libraryUninstalledEmitter.fire(event);
    }
    notifyAttachedBoardsChanged(event) {
        this.attachedBoardsChangedEmitter.fire(event);
    }
    notifyRecentSketchesChanged(event) {
        this.recentSketchesChangedEmitter.fire(event);
    }
};
__decorate([
    inversify_1.inject(notification_service_1.NotificationServiceServer),
    __metadata("design:type", Object)
], NotificationCenter.prototype, "server", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], NotificationCenter.prototype, "init", null);
NotificationCenter = __decorate([
    inversify_1.injectable()
], NotificationCenter);
exports.NotificationCenter = NotificationCenter;
//# sourceMappingURL=notification-center.js.map