"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LibraryListWidgetFrontendContribution = void 0;
const inversify_1 = require("inversify");
const view_contribution_1 = require("@theia/core/lib/browser/shell/view-contribution");
const library_list_widget_1 = require("./library-list-widget");
const arduino_menus_1 = require("../menu/arduino-menus");
const common_1 = require("@theia/core/lib/common");
let LibraryListWidgetFrontendContribution = class LibraryListWidgetFrontendContribution extends view_contribution_1.AbstractViewContribution {
    constructor() {
        super({
            widgetId: library_list_widget_1.LibraryListWidget.WIDGET_ID,
            widgetName: library_list_widget_1.LibraryListWidget.WIDGET_LABEL,
            defaultWidgetOptions: {
                area: 'left',
                rank: 3,
            },
            toggleCommandId: `${library_list_widget_1.LibraryListWidget.WIDGET_ID}:toggle`,
            toggleKeybinding: 'CtrlCmd+Shift+I',
        });
    }
    async initializeLayout() {
        this.openView();
    }
    registerMenus(menus) {
        if (this.toggleCommand) {
            menus.registerMenuAction(arduino_menus_1.ArduinoMenus.TOOLS__MAIN_GROUP, {
                commandId: this.toggleCommand.id,
                label: common_1.nls.localize('arduino/library/manageLibraries', 'Manage Libraries...'),
                order: '3',
            });
        }
    }
};
LibraryListWidgetFrontendContribution = __decorate([
    inversify_1.injectable(),
    __metadata("design:paramtypes", [])
], LibraryListWidgetFrontendContribution);
exports.LibraryListWidgetFrontendContribution = LibraryListWidgetFrontendContribution;
//# sourceMappingURL=library-widget-frontend-contribution.js.map