"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var IDEUpdaterCommands_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterCommands = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("inversify");
const ide_updater_1 = require("../../common/protocol/ide-updater");
const ide_updater_dialog_1 = require("../dialogs/ide-updater/ide-updater-dialog");
let IDEUpdaterCommands = IDEUpdaterCommands_1 = class IDEUpdaterCommands {
    constructor(updater, messageService, updaterDialog) {
        this.updater = updater;
        this.messageService = messageService;
        this.updaterDialog = updaterDialog;
    }
    registerCommands(registry) {
        registry.registerCommand(IDEUpdaterCommands_1.CHECK_FOR_UPDATES, {
            execute: this.checkForUpdates.bind(this),
        });
    }
    async checkForUpdates(initialCheck) {
        try {
            const updateInfo = await this.updater.checkForUpdates(initialCheck);
            if (!!updateInfo) {
                this.updaterDialog.open(updateInfo);
            }
            else {
                this.messageService.info(core_1.nls.localize('arduino/ide-updater/noUpdatesAvailable', 'There are no recent updates available for the Arduino IDE'));
            }
            return updateInfo;
        }
        catch (e) {
            this.messageService.error(core_1.nls.localize('arduino/ide-updater/errorCheckingForUpdates', 'Error while checking for Arduino IDE updates.\n{0}', e.message));
        }
    }
};
IDEUpdaterCommands = IDEUpdaterCommands_1 = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(ide_updater_1.IDEUpdater)),
    __param(1, inversify_1.inject(core_1.MessageService)),
    __param(2, inversify_1.inject(ide_updater_dialog_1.IDEUpdaterDialog)),
    __metadata("design:paramtypes", [Object, core_1.MessageService,
        ide_updater_dialog_1.IDEUpdaterDialog])
], IDEUpdaterCommands);
exports.IDEUpdaterCommands = IDEUpdaterCommands;
(function (IDEUpdaterCommands) {
    IDEUpdaterCommands.CHECK_FOR_UPDATES = {
        id: 'arduino-ide-check-for-updates',
        category: 'Arduino',
        label: 'Check for Arduino IDE updates',
    };
})(IDEUpdaterCommands = exports.IDEUpdaterCommands || (exports.IDEUpdaterCommands = {}));
exports.IDEUpdaterCommands = IDEUpdaterCommands;
//# sourceMappingURL=ide-updater-commands.js.map