"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterClientImpl = void 0;
const core_1 = require("@theia/core");
const inversify_1 = require("@theia/core/shared/inversify");
let IDEUpdaterClientImpl = class IDEUpdaterClientImpl {
    constructor() {
        this.onErrorEmitter = new core_1.Emitter();
        this.onCheckingForUpdateEmitter = new core_1.Emitter();
        this.onUpdateAvailableEmitter = new core_1.Emitter();
        this.onUpdateNotAvailableEmitter = new core_1.Emitter();
        this.onDownloadProgressEmitter = new core_1.Emitter();
        this.onDownloadFinishedEmitter = new core_1.Emitter();
        this.onError = this.onErrorEmitter.event;
        this.onCheckingForUpdate = this.onCheckingForUpdateEmitter.event;
        this.onUpdateAvailable = this.onUpdateAvailableEmitter.event;
        this.onUpdateNotAvailable = this.onUpdateNotAvailableEmitter.event;
        this.onDownloadProgressChanged = this.onDownloadProgressEmitter.event;
        this.onDownloadFinished = this.onDownloadFinishedEmitter.event;
    }
    notifyError(message) {
        this.onErrorEmitter.fire(message);
    }
    notifyCheckingForUpdate(message) {
        this.onCheckingForUpdateEmitter.fire(message);
    }
    notifyUpdateAvailable(message) {
        this.onUpdateAvailableEmitter.fire(message);
    }
    notifyUpdateNotAvailable(message) {
        this.onUpdateNotAvailableEmitter.fire(message);
    }
    notifyDownloadProgressChanged(message) {
        this.onDownloadProgressEmitter.fire(message);
    }
    notifyDownloadFinished(message) {
        this.onDownloadFinishedEmitter.fire(message);
    }
};
IDEUpdaterClientImpl = __decorate([
    inversify_1.injectable()
], IDEUpdaterClientImpl);
exports.IDEUpdaterClientImpl = IDEUpdaterClientImpl;
//# sourceMappingURL=ide-updater-client-impl.js.map