"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserFieldsComponent = void 0;
const React = require("react");
const common_1 = require("@theia/core/lib/common");
exports.UserFieldsComponent = ({ initialBoardUserFields, updateUserFields, cancel, accept, }) => {
    const [boardUserFields, setBoardUserFields] = React.useState(initialBoardUserFields);
    const [uploadButtonDisabled, setUploadButtonDisabled] = React.useState(true);
    React.useEffect(() => {
        setBoardUserFields(initialBoardUserFields);
    }, [initialBoardUserFields]);
    const updateUserField = (index) => (e) => {
        const newBoardUserFields = [...boardUserFields];
        newBoardUserFields[index].value = e.target.value;
        setBoardUserFields(newBoardUserFields);
    };
    const allFieldsHaveValues = (userFields) => {
        return (userFields &&
            userFields.length > 0 &&
            userFields
                .map((field) => {
                return field.value.length > 0;
            })
                .reduce((previous, current) => {
                return previous && current;
            }));
    };
    React.useEffect(() => {
        updateUserFields(boardUserFields);
        setUploadButtonDisabled(!allFieldsHaveValues(boardUserFields));
    }, [boardUserFields]);
    return (React.createElement("div", null,
        React.createElement("div", { className: "user-fields-container" },
            React.createElement("div", { className: "user-fields-list" }, boardUserFields.map((field, index) => {
                return (React.createElement("div", { className: "dialogSection", key: index },
                    React.createElement("div", { className: "dialogRow" },
                        React.createElement("label", { className: "field-label" }, field.label)),
                    React.createElement("div", { className: "dialogRow" },
                        React.createElement("input", { type: field.secret ? 'password' : 'text', value: field.value, className: "theia-input", placeholder: 'Enter ' + field.label, onChange: updateUserField(index) }))));
            }))),
        React.createElement("div", { className: "dialogSection" },
            React.createElement("div", { className: "dialogRow button-container" },
                React.createElement("button", { type: "button", className: "theia-button secondary install-cert-btn", onClick: cancel }, common_1.nls.localize('arduino/userFields/cancel', 'Cancel')),
                React.createElement("button", { type: "button", className: "theia-button primary install-cert-btn", disabled: uploadButtonDisabled, onClick: accept }, common_1.nls.localize('arduino/userFields/upload', 'Upload'))))));
};
//# sourceMappingURL=user-fields-component.js.map