"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsService = exports.Settings = exports.SHOW_ALL_FILES_SETTING = exports.UPLOAD_VERIFY_SETTING = exports.UPLOAD_VERBOSE_SETTING = exports.COMPILE_WARNINGS_SETTING = exports.COMPILE_VERBOSE_SETTING = exports.ZOOM_LEVEL_SETTING = exports.AUTO_SCALE_SETTING = exports.SKETCHBOOK_SETTING = exports.UPLOAD_SETTING = exports.COMPILE_SETTING = exports.WINDOW_SETTING = exports.ARDUINO_SETTING = exports.QUICK_SUGGESTIONS_SETTING = exports.AUTO_SAVE_SETTING = exports.FONT_SIZE_SETTING = exports.EDITOR_SETTING = void 0;
const inversify_1 = require("inversify");
const uri_1 = require("@theia/core/lib/common/uri");
const event_1 = require("@theia/core/lib/common/event");
const promise_util_1 = require("@theia/core/lib/common/promise-util");
const objects_1 = require("@theia/core/lib/common/objects");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const theming_1 = require("@theia/core/lib/browser/theming");
const frontend_application_state_1 = require("@theia/core/lib/browser/frontend-application-state");
const browser_1 = require("@theia/core/lib/browser");
const protocol_1 = require("../../../common/protocol");
const common_1 = require("@theia/core/lib/common");
const localization_1 = require("@theia/core/lib/common/i18n/localization");
exports.EDITOR_SETTING = 'editor';
exports.FONT_SIZE_SETTING = `${exports.EDITOR_SETTING}.fontSize`;
exports.AUTO_SAVE_SETTING = `${exports.EDITOR_SETTING}.autoSave`;
exports.QUICK_SUGGESTIONS_SETTING = `${exports.EDITOR_SETTING}.quickSuggestions`;
exports.ARDUINO_SETTING = 'arduino';
exports.WINDOW_SETTING = `${exports.ARDUINO_SETTING}.window`;
exports.COMPILE_SETTING = `${exports.ARDUINO_SETTING}.compile`;
exports.UPLOAD_SETTING = `${exports.ARDUINO_SETTING}.upload`;
exports.SKETCHBOOK_SETTING = `${exports.ARDUINO_SETTING}.sketchbook`;
exports.AUTO_SCALE_SETTING = `${exports.WINDOW_SETTING}.autoScale`;
exports.ZOOM_LEVEL_SETTING = `${exports.WINDOW_SETTING}.zoomLevel`;
exports.COMPILE_VERBOSE_SETTING = `${exports.COMPILE_SETTING}.verbose`;
exports.COMPILE_WARNINGS_SETTING = `${exports.COMPILE_SETTING}.warnings`;
exports.UPLOAD_VERBOSE_SETTING = `${exports.UPLOAD_SETTING}.verbose`;
exports.UPLOAD_VERIFY_SETTING = `${exports.UPLOAD_SETTING}.verify`;
exports.SHOW_ALL_FILES_SETTING = `${exports.SKETCHBOOK_SETTING}.showAllFiles`;
var Settings;
(function (Settings) {
    function belongsToCli(key) {
        return key === 'sketchbookPath' || key === 'additionalUrls';
    }
    Settings.belongsToCli = belongsToCli;
})(Settings = exports.Settings || (exports.Settings = {}));
let SettingsService = class SettingsService {
    constructor() {
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.ready = new promise_util_1.Deferred();
    }
    async init() {
        const settings = await this.loadSettings();
        this._settings = objects_1.deepClone(settings);
        this.ready.resolve();
    }
    async loadSettings() {
        await this.preferenceService.ready;
        const [languages, currentLanguage, editorFontSize, themeId, autoSave, quickSuggestions, autoScaleInterface, interfaceScale, verboseOnCompile, compilerWarnings, verboseOnUpload, verifyAfterUpload, sketchbookShowAllFiles, cliConfig,] = await Promise.all([
            ['en', ...(await this.localizationProvider.getAvailableLanguages())],
            this.localizationProvider.getCurrentLanguage(),
            this.preferenceService.get(exports.FONT_SIZE_SETTING, 12),
            this.preferenceService.get('workbench.colorTheme', 'arduino-theme'),
            this.preferenceService.get(exports.AUTO_SAVE_SETTING, 'on'),
            this.preferenceService.get(exports.QUICK_SUGGESTIONS_SETTING, {
                other: false,
                comments: false,
                strings: false,
            }),
            this.preferenceService.get(exports.AUTO_SCALE_SETTING, true),
            this.preferenceService.get(exports.ZOOM_LEVEL_SETTING, 0),
            this.preferenceService.get(exports.COMPILE_VERBOSE_SETTING, true),
            this.preferenceService.get(exports.COMPILE_WARNINGS_SETTING, 'None'),
            this.preferenceService.get(exports.UPLOAD_VERBOSE_SETTING, true),
            this.preferenceService.get(exports.UPLOAD_VERIFY_SETTING, true),
            this.preferenceService.get(exports.SHOW_ALL_FILES_SETTING, false),
            this.configService.getConfiguration(),
        ]);
        const { additionalUrls, sketchDirUri, network } = cliConfig;
        const sketchbookPath = await this.fileService.fsPath(new uri_1.default(sketchDirUri));
        return {
            editorFontSize,
            themeId,
            languages,
            currentLanguage,
            autoSave,
            quickSuggestions,
            autoScaleInterface,
            interfaceScale,
            verboseOnCompile,
            compilerWarnings,
            verboseOnUpload,
            verifyAfterUpload,
            sketchbookShowAllFiles,
            additionalUrls,
            sketchbookPath,
            network,
        };
    }
    async settings() {
        await this.ready.promise;
        return this._settings;
    }
    async update(settings, fireDidChange = false) {
        await this.ready.promise;
        for (const key of Object.keys(settings)) {
            this._settings[key] = settings[key];
        }
        if (fireDidChange) {
            this.onDidChangeEmitter.fire(this._settings);
        }
    }
    async reset() {
        const settings = await this.loadSettings();
        return this.update(settings, true);
    }
    async validate(settings = this.settings()) {
        try {
            const { sketchbookPath, editorFontSize, themeId } = await settings;
            const sketchbookDir = await this.fileSystemExt.getUri(sketchbookPath);
            if (!(await this.fileService.exists(new uri_1.default(sketchbookDir)))) {
                return common_1.nls.localize('arduino/preferences/invalid.sketchbook.location', 'Invalid sketchbook location: {0}', sketchbookPath);
            }
            if (editorFontSize <= 0) {
                return common_1.nls.localize('arduino/preferences/invalid.editorFontSize', 'Invalid editor font size. It must be a positive integer.');
            }
            if (!theming_1.ThemeService.get()
                .getThemes()
                .find(({ id }) => id === themeId)) {
                return common_1.nls.localize('arduino/preferences/invalid.theme', 'Invalid theme.');
            }
            return true;
        }
        catch (err) {
            if (err instanceof Error) {
                return err.message;
            }
            return String(err);
        }
    }
    async savePreference(name, value) {
        await this.preferenceService.set(name, value, browser_1.PreferenceScope.User);
        await promise_util_1.timeout(5);
    }
    async save() {
        await this.ready.promise;
        const { currentLanguage, editorFontSize, themeId, autoSave, quickSuggestions, autoScaleInterface, interfaceScale, verboseOnCompile, compilerWarnings, verboseOnUpload, verifyAfterUpload, sketchbookPath, additionalUrls, network, sketchbookShowAllFiles, } = this._settings;
        const [config, sketchDirUri] = await Promise.all([
            this.configService.getConfiguration(),
            this.fileSystemExt.getUri(sketchbookPath),
        ]);
        config.additionalUrls = additionalUrls;
        config.sketchDirUri = sketchDirUri;
        config.network = network;
        config.locale = currentLanguage;
        await this.savePreference('editor.fontSize', editorFontSize);
        await this.savePreference('workbench.colorTheme', themeId);
        await this.savePreference('editor.autoSave', autoSave);
        await this.savePreference('editor.quickSuggestions', quickSuggestions);
        await this.savePreference(exports.AUTO_SCALE_SETTING, autoScaleInterface);
        await this.savePreference(exports.ZOOM_LEVEL_SETTING, interfaceScale);
        await this.savePreference(exports.ZOOM_LEVEL_SETTING, interfaceScale);
        await this.savePreference(exports.COMPILE_VERBOSE_SETTING, verboseOnCompile);
        await this.savePreference(exports.COMPILE_WARNINGS_SETTING, compilerWarnings);
        await this.savePreference(exports.UPLOAD_VERBOSE_SETTING, verboseOnUpload);
        await this.savePreference(exports.UPLOAD_VERIFY_SETTING, verifyAfterUpload);
        await this.savePreference(exports.SHOW_ALL_FILES_SETTING, sketchbookShowAllFiles);
        await this.configService.setConfiguration(config);
        this.onDidChangeEmitter.fire(this._settings);
        // after saving all the settings, if we need to change the language we need to perform a reload
        // Only reload if the language differs from the current locale. `nls.locale === undefined` signals english as well
        if (currentLanguage !== common_1.nls.locale && !(currentLanguage === 'en' && common_1.nls.locale === undefined)) {
            if (currentLanguage === 'en') {
                window.localStorage.removeItem(common_1.nls.localeId);
            }
            else {
                window.localStorage.setItem(common_1.nls.localeId, currentLanguage);
            }
            window.location.reload();
        }
        return true;
    }
};
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SettingsService.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(protocol_1.FileSystemExt),
    __metadata("design:type", Object)
], SettingsService.prototype, "fileSystemExt", void 0);
__decorate([
    inversify_1.inject(protocol_1.ConfigService),
    __metadata("design:type", Object)
], SettingsService.prototype, "configService", void 0);
__decorate([
    inversify_1.inject(browser_1.PreferenceService),
    __metadata("design:type", Object)
], SettingsService.prototype, "preferenceService", void 0);
__decorate([
    inversify_1.inject(frontend_application_state_1.FrontendApplicationStateService),
    __metadata("design:type", frontend_application_state_1.FrontendApplicationStateService)
], SettingsService.prototype, "appStateService", void 0);
__decorate([
    inversify_1.inject(localization_1.AsyncLocalizationProvider),
    __metadata("design:type", Object)
], SettingsService.prototype, "localizationProvider", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], SettingsService.prototype, "init", null);
SettingsService = __decorate([
    inversify_1.injectable()
], SettingsService);
exports.SettingsService = SettingsService;
//# sourceMappingURL=settings.js.map