"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AdditionalUrlsDialog = exports.SettingsDialog = exports.SettingsDialogProps = exports.SettingsWidget = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const widgets_1 = require("@phosphor/widgets");
const browser_1 = require("@theia/core/lib/browser");
const browser_2 = require("@theia/core/lib/browser");
const settings_1 = require("./settings");
const file_service_1 = require("@theia/filesystem/lib/browser/file-service");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
const file_dialog_service_1 = require("@theia/filesystem/lib/browser/file-dialog/file-dialog-service");
const common_1 = require("@theia/core/lib/common");
const settings_component_1 = require("./settings-component");
const localization_1 = require("@theia/core/lib/common/i18n/localization");
let SettingsWidget = class SettingsWidget extends browser_1.ReactWidget {
    render() {
        return (React.createElement(settings_component_1.SettingsComponent, { settingsService: this.settingsService, fileService: this.fileService, fileDialogService: this.fileDialogService, windowService: this.windowService, localizationProvider: this.localizationProvider }));
    }
};
__decorate([
    inversify_1.inject(settings_1.SettingsService),
    __metadata("design:type", settings_1.SettingsService)
], SettingsWidget.prototype, "settingsService", void 0);
__decorate([
    inversify_1.inject(file_service_1.FileService),
    __metadata("design:type", file_service_1.FileService)
], SettingsWidget.prototype, "fileService", void 0);
__decorate([
    inversify_1.inject(file_dialog_service_1.FileDialogService),
    __metadata("design:type", Object)
], SettingsWidget.prototype, "fileDialogService", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], SettingsWidget.prototype, "windowService", void 0);
__decorate([
    inversify_1.inject(localization_1.AsyncLocalizationProvider),
    __metadata("design:type", Object)
], SettingsWidget.prototype, "localizationProvider", void 0);
SettingsWidget = __decorate([
    inversify_1.injectable()
], SettingsWidget);
exports.SettingsWidget = SettingsWidget;
let SettingsDialogProps = class SettingsDialogProps extends browser_2.DialogProps {
};
SettingsDialogProps = __decorate([
    inversify_1.injectable()
], SettingsDialogProps);
exports.SettingsDialogProps = SettingsDialogProps;
let SettingsDialog = class SettingsDialog extends browser_2.AbstractDialog {
    constructor(props) {
        super(props);
        this.props = props;
        this.contentNode.classList.add('arduino-settings-dialog');
        this.appendCloseButton(common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'));
        this.appendAcceptButton(common_1.nls.localize('vscode/issueMainService/ok', 'OK'));
    }
    init() {
        this.toDispose.push(this.settingsService.onDidChange(this.validate.bind(this)));
    }
    async isValid(settings) {
        const result = await this.settingsService.validate(settings);
        if (typeof result === 'string') {
            return result;
        }
        return '';
    }
    get value() {
        return this.settingsService.settings();
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        this.toDisposeOnDetach.push(this.settingsService.onDidChange(() => this.update()));
        super.onAfterAttach(msg);
        this.update();
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        // calling settingsService.reset() in order to reload the settings from the preferenceService
        // and update the UI including changes triggerd from the command palette
        this.settingsService.reset();
        this.widget.activate();
    }
};
__decorate([
    inversify_1.inject(settings_1.SettingsService),
    __metadata("design:type", settings_1.SettingsService)
], SettingsDialog.prototype, "settingsService", void 0);
__decorate([
    inversify_1.inject(SettingsWidget),
    __metadata("design:type", SettingsWidget)
], SettingsDialog.prototype, "widget", void 0);
__decorate([
    inversify_1.postConstruct(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", void 0)
], SettingsDialog.prototype, "init", null);
SettingsDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(SettingsDialogProps)),
    __metadata("design:paramtypes", [SettingsDialogProps])
], SettingsDialog);
exports.SettingsDialog = SettingsDialog;
class AdditionalUrlsDialog extends browser_2.AbstractDialog {
    constructor(urls, windowService) {
        super({
            title: common_1.nls.localize('arduino/preferences/additionalManagerURLs', 'Additional Boards Manager URLs'),
        });
        this.contentNode.classList.add('additional-urls-dialog');
        const description = document.createElement('div');
        description.textContent = common_1.nls.localize('arduino/preferences/enterAdditionalURLs', 'Enter additional URLs, one for each row');
        description.style.marginBottom = '5px';
        this.contentNode.appendChild(description);
        this.textArea = document.createElement('textarea');
        this.textArea.className = 'theia-input';
        this.textArea.setAttribute('style', 'flex: 0;');
        this.textArea.value = urls
            .filter((url) => url.trim())
            .filter((url) => !!url)
            .join('\n');
        this.textArea.wrap = 'soft';
        this.textArea.cols = 90;
        this.textArea.rows = 5;
        this.contentNode.appendChild(this.textArea);
        const anchor = document.createElement('div');
        anchor.classList.add('link');
        anchor.textContent = common_1.nls.localize('arduino/preferences/unofficialBoardSupport', 'Click for a list of unofficial board support URLs');
        anchor.style.marginTop = '5px';
        anchor.style.cursor = 'pointer';
        this.addEventListener(anchor, 'click', () => windowService.openNewWindow('https://github.com/arduino/Arduino/wiki/Unofficial-list-of-3rd-party-boards-support-urls', { external: true }));
        this.contentNode.appendChild(anchor);
        this.appendAcceptButton(common_1.nls.localize('vscode/issueMainService/ok', 'OK'));
        this.appendCloseButton(common_1.nls.localize('vscode/issueMainService/cancel', 'Cancel'));
    }
    get value() {
        return this.textArea.value
            .split('\n')
            .map((url) => url.trim())
            .filter((url) => !!url);
    }
    onAfterAttach(message) {
        super.onAfterAttach(message);
        this.addUpdateListener(this.textArea, 'input');
    }
    onActivateRequest(message) {
        super.onActivateRequest(message);
        this.textArea.focus();
    }
    handleEnter(event) {
        if (event.target instanceof HTMLInputElement) {
            return super.handleEnter(event);
        }
        return false;
    }
}
exports.AdditionalUrlsDialog = AdditionalUrlsDialog;
//# sourceMappingURL=settings-dialog.js.map