"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SettingsComponent = void 0;
const React = require("react");
const react_tabs_1 = require("react-tabs");
require("react-tabs/style/react-tabs.css");
const react_disable_1 = require("react-disable");
const objects_1 = require("@theia/core/lib/common/objects");
const theming_1 = require("@theia/core/lib/browser/theming");
const disposable_1 = require("@theia/core/lib/common/disposable");
const protocol_1 = require("../../../common/protocol");
const common_1 = require("@theia/core/lib/common");
const settings_dialog_1 = require("./settings-dialog");
class SettingsComponent extends React.Component {
    constructor(props) {
        super(props);
        this.toDispose = new disposable_1.DisposableCollection();
        this.noopKeyDown = (event) => {
            if (this.isControlKey(event)) {
                return;
            }
            event.nativeEvent.preventDefault();
            event.nativeEvent.returnValue = false;
        };
        this.numbersOnlyKeyDown = (event) => {
            if (this.isControlKey(event)) {
                return;
            }
            const key = Number(event.key);
            if (isNaN(key) || event.key === null || event.key === ' ') {
                event.nativeEvent.preventDefault();
                event.nativeEvent.returnValue = false;
                return;
            }
        };
        this.browseSketchbookDidClick = async () => {
            const uri = await this.props.fileDialogService.showOpenDialog({
                title: common_1.nls.localize('arduino/preferences/newSketchbookLocation', 'Select new sketchbook location'),
                openLabel: common_1.nls.localize('arduino/preferences/choose', 'Choose'),
                canSelectFiles: false,
                canSelectMany: false,
                canSelectFolders: true,
            });
            if (uri) {
                const sketchbookPath = await this.props.fileService.fsPath(uri);
                this.setState({ sketchbookPath });
            }
        };
        this.editAdditionalUrlDidClick = async () => {
            const additionalUrls = await new settings_dialog_1.AdditionalUrlsDialog(this.state.additionalUrls, this.props.windowService).open();
            if (additionalUrls) {
                this.setState({ additionalUrls });
            }
        };
        this.editorFontSizeDidChange = (event) => {
            const { value } = event.target;
            if (value) {
                this.setState({ editorFontSize: parseInt(value, 10) });
            }
        };
        this.additionalUrlsDidChange = (event) => {
            this.setState({
                additionalUrls: event.target.value.split(',').map((url) => url.trim()),
            });
        };
        this.autoScaleInterfaceDidChange = (event) => {
            this.setState({ autoScaleInterface: event.target.checked });
        };
        this.interfaceScaleDidChange = (event) => {
            const { value } = event.target;
            const percentage = parseInt(value, 10);
            if (isNaN(percentage)) {
                return;
            }
            const interfaceScale = (percentage - 100) / 20;
            if (!isNaN(interfaceScale)) {
                this.setState({ interfaceScale });
            }
        };
        this.verifyAfterUploadDidChange = (event) => {
            this.setState({ verifyAfterUpload: event.target.checked });
        };
        this.sketchbookShowAllFilesDidChange = (event) => {
            this.setState({ sketchbookShowAllFiles: event.target.checked });
        };
        this.autoSaveDidChange = (event) => {
            this.setState({ autoSave: event.target.checked ? 'on' : 'off' });
        };
        this.quickSuggestionsOtherDidChange = (event) => {
            // need to persist react events through lifecycle https://reactjs.org/docs/events.html#event-pooling
            const newVal = event.target.checked ? true : false;
            this.setState((prevState) => {
                return {
                    quickSuggestions: Object.assign(Object.assign({}, prevState.quickSuggestions), { other: newVal }),
                };
            });
        };
        this.themeDidChange = (event) => {
            const { selectedIndex } = event.target.options;
            const theme = theming_1.ThemeService.get().getThemes()[selectedIndex];
            if (theme) {
                this.setState({ themeId: theme.id });
            }
        };
        this.languageDidChange = (event) => {
            const selectedLanguage = event.target.value;
            this.setState({ currentLanguage: selectedLanguage });
        };
        this.compilerWarningsDidChange = (event) => {
            const { selectedIndex } = event.target.options;
            const compilerWarnings = protocol_1.CompilerWarningLiterals[selectedIndex];
            if (compilerWarnings) {
                this.setState({ compilerWarnings });
            }
        };
        this.verboseOnCompileDidChange = (event) => {
            this.setState({ verboseOnCompile: event.target.checked });
        };
        this.verboseOnUploadDidChange = (event) => {
            this.setState({ verboseOnUpload: event.target.checked });
        };
        this.sketchpathDidChange = (event) => {
            const sketchbookPath = event.target.value;
            if (sketchbookPath) {
                this.setState({ sketchbookPath });
            }
        };
        this.noProxyDidChange = (event) => {
            if (event.target.checked) {
                this.setState({ network: 'none' });
            }
            else {
                this.setState({ network: protocol_1.Network.Default() });
            }
        };
        this.manualProxyDidChange = (event) => {
            if (event.target.checked) {
                this.setState({ network: protocol_1.Network.Default() });
            }
            else {
                this.setState({ network: 'none' });
            }
        };
        this.httpProtocolDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.protocol = event.target.checked ? 'http' : 'socks';
                this.setState({ network });
            }
        };
        this.socksProtocolDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.protocol = event.target.checked ? 'socks' : 'http';
                this.setState({ network });
            }
        };
        this.hostnameDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.hostname = event.target.value;
                this.setState({ network });
            }
        };
        this.portDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.port = event.target.value;
                this.setState({ network });
            }
        };
        this.usernameDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.username = event.target.value;
                this.setState({ network });
            }
        };
        this.passwordDidChange = (event) => {
            if (this.state.network !== 'none') {
                const network = this.cloneProxySettings;
                network.password = event.target.value;
                this.setState({ network });
            }
        };
    }
    componentDidUpdate(_, prevState) {
        if (this.state &&
            prevState &&
            JSON.stringify(this.state) !== JSON.stringify(prevState)) {
            this.props.settingsService.update(this.state, true);
        }
    }
    componentDidMount() {
        this.props.settingsService
            .settings()
            .then((settings) => this.setState(settings));
        this.toDispose.push(this.props.settingsService.onDidChange((settings) => this.setState(settings)));
    }
    componentWillUnmount() {
        this.toDispose.dispose();
    }
    render() {
        if (!this.state) {
            return React.createElement("div", null);
        }
        return (React.createElement(react_tabs_1.Tabs, null,
            React.createElement(react_tabs_1.TabList, null,
                React.createElement(react_tabs_1.Tab, null, common_1.nls.localize('vscode/settingsTree/settings', 'Settings')),
                React.createElement(react_tabs_1.Tab, null, common_1.nls.localize('arduino/preferences/network', 'Network'))),
            React.createElement(react_tabs_1.TabPanel, null, this.renderSettings()),
            React.createElement(react_tabs_1.TabPanel, null, this.renderNetwork())));
    }
    renderSettings() {
        var _a;
        return (React.createElement("div", { className: "content noselect" },
            common_1.nls.localize('arduino/preferences/sketchbook.location', 'Sketchbook location') + ':',
            React.createElement("div", { className: "flex-line" },
                React.createElement("input", { className: "theia-input stretch", type: "text", value: this.state.sketchbookPath, onChange: this.sketchpathDidChange }),
                React.createElement("button", { className: "theia-button shrink", onClick: this.browseSketchbookDidClick }, common_1.nls.localize('arduino/preferences/browse', 'Browse'))),
            React.createElement("label", { className: "flex-line" },
                React.createElement("input", { type: "checkbox", checked: this.state.sketchbookShowAllFiles === true, onChange: this.sketchbookShowAllFilesDidChange }),
                common_1.nls.localize('arduino/preferences/files.inside.sketches', 'Show files inside Sketches')),
            React.createElement("div", { className: "flex-line" },
                React.createElement("div", { className: "column" },
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('arduino/preferences/editorFontSize', 'Editor font size') + ':'),
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('arduino/preferences/interfaceScale', 'Interface scale') + ':'),
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('vscode/themes.contribution/selectTheme.label', 'Theme') + ':'),
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('vscode/editorStatus/status.editor.mode', 'Language') + ':'),
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('arduino/preferences/showVerbose', 'Show verbose output during')),
                    React.createElement("div", { className: "flex-line" }, common_1.nls.localize('arduino/preferences/compilerWarnings', 'Compiler warnings'))),
                React.createElement("div", { className: "column" },
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("input", { className: "theia-input small", type: "number", step: 1, pattern: "[0-9]+", onKeyDown: this.numbersOnlyKeyDown, value: this.state.editorFontSize, onChange: this.editorFontSizeDidChange })),
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("label", { className: "flex-line" },
                            React.createElement("input", { type: "checkbox", checked: this.state.autoScaleInterface, onChange: this.autoScaleInterfaceDidChange }),
                            common_1.nls.localize('arduino/preferences/automatic', 'Automatic')),
                        React.createElement("input", { className: "theia-input small with-margin", type: "number", step: 20, pattern: "[0-9]+", onKeyDown: this.noopKeyDown, value: 100 + this.state.interfaceScale * 20, onChange: this.interfaceScaleDidChange }),
                        "%"),
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("select", { className: "theia-select", value: ((_a = theming_1.ThemeService.get()
                                .getThemes()
                                .find(({ id }) => id === this.state.themeId)) === null || _a === void 0 ? void 0 : _a.label) ||
                                common_1.nls.localize('arduino/common/unknown', 'Unknown'), onChange: this.themeDidChange }, theming_1.ThemeService.get()
                            .getThemes()
                            .map(({ id, label }) => (React.createElement("option", { key: id, value: label }, label))))),
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("select", { className: "theia-select", value: this.state.currentLanguage, onChange: this.languageDidChange }, this.state.languages.map((label) => (React.createElement("option", { key: label, value: label }, label)))),
                        React.createElement("span", { style: { marginLeft: '5px' } },
                            "(",
                            common_1.nls.localize('vscode/extensionsActions/reloadRequired', 'Reload required'),
                            ")")),
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("label", { className: "flex-line" },
                            React.createElement("input", { type: "checkbox", checked: this.state.verboseOnCompile, onChange: this.verboseOnCompileDidChange }),
                            common_1.nls.localize('arduino/preferences/compile', 'compile')),
                        React.createElement("label", { className: "flex-line" },
                            React.createElement("input", { type: "checkbox", checked: this.state.verboseOnUpload, onChange: this.verboseOnUploadDidChange }),
                            common_1.nls.localize('arduino/preferences/upload', 'upload'))),
                    React.createElement("div", { className: "flex-line" },
                        React.createElement("select", { className: "theia-select", value: this.state.compilerWarnings, onChange: this.compilerWarningsDidChange }, protocol_1.CompilerWarningLiterals.map((value) => (React.createElement("option", { key: value, value: value }, value))))))),
            React.createElement("label", { className: "flex-line" },
                React.createElement("input", { type: "checkbox", checked: this.state.verifyAfterUpload, onChange: this.verifyAfterUploadDidChange }),
                common_1.nls.localize('arduino/preferences/verifyAfterUpload', 'Verify code after upload')),
            React.createElement("label", { className: "flex-line" },
                React.createElement("input", { type: "checkbox", checked: this.state.autoSave === 'on', onChange: this.autoSaveDidChange }),
                common_1.nls.localize('vscode/fileActions.contribution/miAutoSave', 'Auto save')),
            React.createElement("label", { className: "flex-line" },
                React.createElement("input", { type: "checkbox", checked: this.state.quickSuggestions.other === true, onChange: this.quickSuggestionsOtherDidChange }),
                common_1.nls.localize('arduino/preferences/editorQuickSuggestions', 'Editor Quick Suggestions')),
            React.createElement("div", { className: "flex-line" },
                common_1.nls.localize('arduino/preferences/additionalManagerURLs', 'Additional boards manager URLs') + ':',
                React.createElement("input", { className: "theia-input stretch with-margin", type: "text", value: this.state.additionalUrls.join(','), onChange: this.additionalUrlsDidChange }),
                React.createElement("i", { className: "fa fa-window-restore theia-button shrink", onClick: this.editAdditionalUrlDidClick }))));
    }
    renderNetwork() {
        return (React.createElement("div", { className: "content noselect" },
            React.createElement("form", null,
                React.createElement("label", { className: "flex-line" },
                    React.createElement("input", { type: "radio", checked: this.state.network === 'none', onChange: this.noProxyDidChange }),
                    common_1.nls.localize('arduino/preferences/noProxy', 'No proxy')),
                React.createElement("label", { className: "flex-line" },
                    React.createElement("input", { type: "radio", checked: this.state.network !== 'none', onChange: this.manualProxyDidChange }),
                    common_1.nls.localize('arduino/preferences/manualProxy', 'Manual proxy configuration'))),
            this.renderProxySettings()));
    }
    renderProxySettings() {
        const disabled = this.state.network === 'none';
        return (React.createElement(react_disable_1.Disable, { disabled: disabled },
            React.createElement("div", { className: "proxy-settings", "aria-disabled": disabled },
                React.createElement("form", { className: "flex-line" },
                    React.createElement("input", { type: "radio", checked: this.state.network === 'none'
                            ? true
                            : this.state.network.protocol === 'http', onChange: this.httpProtocolDidChange }),
                    "HTTP",
                    React.createElement("label", { className: "flex-line" },
                        React.createElement("input", { type: "radio", checked: this.state.network === 'none'
                                ? false
                                : this.state.network.protocol !== 'http', onChange: this.socksProtocolDidChange }),
                        "SOCKS")),
                React.createElement("div", { className: "flex-line proxy-settings" },
                    React.createElement("div", { className: "column" },
                        React.createElement("div", { className: "flex-line" }, "Host name:"),
                        React.createElement("div", { className: "flex-line" }, "Port number:"),
                        React.createElement("div", { className: "flex-line" }, "Username:"),
                        React.createElement("div", { className: "flex-line" }, "Password:")),
                    React.createElement("div", { className: "column stretch" },
                        React.createElement("div", { className: "flex-line" },
                            React.createElement("input", { className: "theia-input stretch with-margin", type: "text", value: this.state.network === 'none'
                                    ? ''
                                    : this.state.network.hostname, onChange: this.hostnameDidChange })),
                        React.createElement("div", { className: "flex-line" },
                            React.createElement("input", { className: "theia-input small with-margin", type: "number", pattern: "[0-9]", value: this.state.network === 'none' ? '' : this.state.network.port, onKeyDown: this.numbersOnlyKeyDown, onChange: this.portDidChange })),
                        React.createElement("div", { className: "flex-line" },
                            React.createElement("input", { className: "theia-input stretch with-margin", type: "text", value: this.state.network === 'none'
                                    ? ''
                                    : this.state.network.username, onChange: this.usernameDidChange })),
                        React.createElement("div", { className: "flex-line" },
                            React.createElement("input", { className: "theia-input stretch with-margin", type: "password", value: this.state.network === 'none'
                                    ? ''
                                    : this.state.network.password, onChange: this.passwordDidChange })))))));
    }
    isControlKey(event) {
        return (!!event.key &&
            ['tab', 'delete', 'backspace', 'arrowleft', 'arrowright'].some((key) => event.key.toLocaleLowerCase() === key));
    }
    get cloneProxySettings() {
        const { network } = this.state;
        if (network === 'none') {
            throw new Error('Must be called when proxy is enabled.');
        }
        const copyNetwork = objects_1.deepClone(network);
        return copyNetwork;
    }
}
exports.SettingsComponent = SettingsComponent;
//# sourceMappingURL=settings-component.js.map