"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterDialog = exports.IDEUpdaterDialogProps = exports.IDEUpdaterDialogWidget = void 0;
const React = require("react");
const inversify_1 = require("inversify");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const dialogs_2 = require("../../theia/dialogs/dialogs");
const widgets_1 = require("@phosphor/widgets");
const react_widget_1 = require("@theia/core/lib/browser/widgets/react-widget");
const core_1 = require("@theia/core");
const ide_updater_component_1 = require("./ide-updater-component");
const ide_updater_1 = require("../../../common/protocol/ide-updater");
const browser_1 = require("@theia/core/lib/browser");
const arduino_frontend_contribution_1 = require("../../arduino-frontend-contribution");
const window_service_1 = require("@theia/core/lib/browser/window/window-service");
let IDEUpdaterDialogWidget = class IDEUpdaterDialogWidget extends react_widget_1.ReactWidget {
    constructor() {
        super(...arguments);
        this.isOpen = new Object();
    }
    init(updateInfo, onClose) {
        this.updateInfo = updateInfo;
        this.progressInfo = undefined;
        this.error = undefined;
        this.downloadStarted = false;
        this.downloadFinished = false;
        this.onClose = onClose;
        this.updaterClient.onError((e) => {
            this.error = e;
            this.update();
        });
        this.updaterClient.onDownloadProgressChanged((e) => {
            this.progressInfo = e;
            this.update();
        });
        this.updaterClient.onDownloadFinished((e) => {
            this.downloadFinished = true;
            this.update();
        });
    }
    async onSkipVersion() {
        this.localStorageService.setData(arduino_frontend_contribution_1.SKIP_IDE_VERSION, this.updateInfo.version);
        this.close();
    }
    close() {
        super.close();
        this.onClose();
    }
    onDispose() {
        if (this.downloadStarted && !this.downloadFinished)
            this.updater.stopDownload();
    }
    async onDownload() {
        this.progressInfo = undefined;
        this.downloadStarted = true;
        this.error = undefined;
        this.updater.downloadUpdate();
        this.update();
    }
    onCloseAndInstall() {
        this.updater.quitAndInstall();
    }
    render() {
        return !!this.updateInfo ? (React.createElement("form", null,
            React.createElement(ide_updater_component_1.IDEUpdaterComponent, { updateInfo: this.updateInfo, windowService: this.windowService, downloadStarted: this.downloadStarted, downloadFinished: this.downloadFinished, progress: this.progressInfo, error: this.error, onClose: this.close.bind(this), onSkipVersion: this.onSkipVersion.bind(this), onDownload: this.onDownload.bind(this), onCloseAndInstall: this.onCloseAndInstall.bind(this) }))) : null;
    }
};
__decorate([
    inversify_1.inject(ide_updater_1.IDEUpdater),
    __metadata("design:type", Object)
], IDEUpdaterDialogWidget.prototype, "updater", void 0);
__decorate([
    inversify_1.inject(ide_updater_1.IDEUpdaterClient),
    __metadata("design:type", Object)
], IDEUpdaterDialogWidget.prototype, "updaterClient", void 0);
__decorate([
    inversify_1.inject(browser_1.LocalStorageService),
    __metadata("design:type", browser_1.LocalStorageService)
], IDEUpdaterDialogWidget.prototype, "localStorageService", void 0);
__decorate([
    inversify_1.inject(window_service_1.WindowService),
    __metadata("design:type", Object)
], IDEUpdaterDialogWidget.prototype, "windowService", void 0);
IDEUpdaterDialogWidget = __decorate([
    inversify_1.injectable()
], IDEUpdaterDialogWidget);
exports.IDEUpdaterDialogWidget = IDEUpdaterDialogWidget;
let IDEUpdaterDialogProps = class IDEUpdaterDialogProps extends dialogs_1.DialogProps {
};
IDEUpdaterDialogProps = __decorate([
    inversify_1.injectable()
], IDEUpdaterDialogProps);
exports.IDEUpdaterDialogProps = IDEUpdaterDialogProps;
let IDEUpdaterDialog = class IDEUpdaterDialog extends dialogs_2.AbstractDialog {
    constructor(props) {
        super({
            title: core_1.nls.localize('arduino/ide-updater/ideUpdaterDialog', 'Software Update'),
        });
        this.props = props;
        this.contentNode.classList.add('ide-updater-dialog');
        this.acceptButton = undefined;
    }
    get value() {
        return this.widget.updateInfo;
    }
    onAfterAttach(msg) {
        if (this.widget.isAttached) {
            widgets_1.Widget.detach(this.widget);
        }
        widgets_1.Widget.attach(this.widget, this.contentNode);
        super.onAfterAttach(msg);
        this.update();
    }
    async open(data = undefined) {
        if (data && data.version) {
            this.widget.init(data, this.close.bind(this));
            return super.open();
        }
    }
    onUpdateRequest(msg) {
        super.onUpdateRequest(msg);
        this.widget.update();
    }
    onActivateRequest(msg) {
        super.onActivateRequest(msg);
        this.widget.activate();
    }
    close() {
        this.widget.dispose();
        super.close();
    }
};
__decorate([
    inversify_1.inject(IDEUpdaterDialogWidget),
    __metadata("design:type", IDEUpdaterDialogWidget)
], IDEUpdaterDialog.prototype, "widget", void 0);
IDEUpdaterDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(IDEUpdaterDialogProps)),
    __metadata("design:paramtypes", [IDEUpdaterDialogProps])
], IDEUpdaterDialog);
exports.IDEUpdaterDialog = IDEUpdaterDialog;
//# sourceMappingURL=ide-updater-dialog.js.map