"use strict";
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.IDEUpdaterComponent = void 0;
const common_1 = require("@theia/core/lib/common");
const electron_1 = require("electron");
const React = require("react");
const ReactDOM = require("react-dom");
const react_markdown_1 = require("react-markdown");
const ProgressBar_1 = require("../../components/ProgressBar");
exports.IDEUpdaterComponent = ({ updateInfo: { version, releaseNotes }, downloadStarted = false, downloadFinished = false, windowService, progress, error, onDownload, onClose, onSkipVersion, onCloseAndInstall, }) => {
    const changelogDivRef = React.useRef();
    React.useEffect(() => {
        if (!!releaseNotes) {
            let changelog;
            if (typeof releaseNotes === 'string')
                changelog = releaseNotes;
            else
                changelog = releaseNotes.reduce((acc, item) => {
                    return item.note ? (acc += `${item.note}\n\n`) : acc;
                }, '');
            ReactDOM.render(React.createElement(react_markdown_1.default, { components: {
                    a: (_a) => {
                        var { href, children } = _a, props = __rest(_a, ["href", "children"]);
                        return (React.createElement("a", Object.assign({ onClick: () => href && electron_1.shell.openExternal(href) }, props), children));
                    },
                } }, changelog), changelogDivRef.current);
        }
    }, [releaseNotes]);
    const closeButton = (React.createElement("button", { onClick: onClose, type: "button", className: "theia-button secondary" }, common_1.nls.localize('arduino/ide-updater/notNowButton', 'Not now')));
    const DownloadCompleted = () => (React.createElement("div", { className: "ide-updater-dialog--downloaded" },
        React.createElement("div", null, common_1.nls.localize('arduino/ide-updater/versionDownloaded', 'Arduino IDE {0} has been downloaded.', version)),
        React.createElement("div", null, common_1.nls.localize('arduino/ide-updater/closeToInstallNotice', 'Close the software and install the update on your machine.')),
        React.createElement("div", { className: "buttons-container" },
            closeButton,
            React.createElement("button", { onClick: onCloseAndInstall, type: "button", className: "theia-button close-and-install" }, common_1.nls.localize('arduino/ide-updater/closeAndInstallButton', 'Close and Install')))));
    const DownloadStarted = () => (React.createElement("div", { className: "ide-updater-dialog--downloading" },
        React.createElement("div", null, common_1.nls.localize('arduino/ide-updater/downloadingNotice', 'Downloading the latest version of the Arduino IDE.')),
        React.createElement(ProgressBar_1.default, { percent: progress === null || progress === void 0 ? void 0 : progress.percent, showPercentage: true })));
    const PreDownload = () => (React.createElement("div", { className: "ide-updater-dialog--pre-download" },
        React.createElement("div", { className: "ide-updater-dialog--logo-container" },
            React.createElement("div", { className: "ide-updater-dialog--logo" })),
        React.createElement("div", { className: "ide-updater-dialog--new-version-text dialogSection" },
            React.createElement("div", { className: "dialogRow" },
                React.createElement("div", { className: "bold" }, common_1.nls.localize('arduino/ide-updater/updateAvailable', 'Update Available'))),
            React.createElement("div", { className: "dialogRow" }, common_1.nls.localize('arduino/ide-updater/newVersionAvailable', 'A new version of Arduino IDE ({0}) is available for download.', version)),
            releaseNotes && (React.createElement("div", { className: "dialogRow" },
                React.createElement("div", { className: "changelog-container", ref: changelogDivRef }))),
            React.createElement("div", { className: "buttons-container" },
                React.createElement("button", { onClick: onSkipVersion, type: "button", className: "theia-button secondary skip-version" }, common_1.nls.localize('arduino/ide-updater/skipVersionButton', 'Skip Version')),
                React.createElement("div", { className: "push" }),
                closeButton,
                React.createElement("button", { onClick: onDownload, type: "button", className: "theia-button primary" }, common_1.nls.localize('arduino/ide-updater/downloadButton', 'Download'))))));
    const onGoToDownloadClick = (event) => {
        const { target } = event.nativeEvent;
        if (target instanceof HTMLAnchorElement) {
            event.nativeEvent.preventDefault();
            windowService.openNewWindow(target.href, { external: true });
            onClose();
        }
    };
    const GoToDownloadPage = () => (React.createElement("div", { className: "ide-updater-dialog--go-to-download-page" },
        React.createElement("div", null, common_1.nls.localize('arduino/ide-updater/goToDownloadPage', "An update for the Arduino IDE is available, but we're not able to download and install it automatically. Please go to the download page and download the latest version from there.")),
        React.createElement("div", { className: "buttons-container" },
            closeButton,
            React.createElement("a", { className: "theia-button primary", href: "https://www.arduino.cc/en/software#experimental-software", onClick: onGoToDownloadClick }, common_1.nls.localize('arduino/ide-updater/goToDownloadButton', 'Go To Download')))));
    return (React.createElement("div", { className: "ide-updater-dialog--content" }, !!error ? (React.createElement(GoToDownloadPage, null)) : downloadFinished ? (React.createElement(DownloadCompleted, null)) : downloadStarted ? (React.createElement(DownloadStarted, null)) : (React.createElement(PreDownload, null))));
};
//# sourceMappingURL=ide-updater-component.js.map