"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DoNotAskAgainConfirmDialog = exports.DoNotAskAgainDialogProps = void 0;
const inversify_1 = require("inversify");
const widgets_1 = require("@phosphor/widgets");
const cancellation_1 = require("@theia/core/lib/common/cancellation");
const dialogs_1 = require("@theia/core/lib/browser/dialogs");
const common_1 = require("@theia/core/lib/common");
let DoNotAskAgainDialogProps = class DoNotAskAgainDialogProps extends dialogs_1.ConfirmDialogProps {
};
DoNotAskAgainDialogProps = __decorate([
    inversify_1.injectable()
], DoNotAskAgainDialogProps);
exports.DoNotAskAgainDialogProps = DoNotAskAgainDialogProps;
let DoNotAskAgainConfirmDialog = class DoNotAskAgainConfirmDialog extends dialogs_1.ConfirmDialog {
    constructor(props) {
        super(props);
        this.props = props;
        this.controlPanel.removeChild(this.errorMessageNode);
        const doNotAskAgainNode = document.createElement('div');
        doNotAskAgainNode.setAttribute('style', 'flex: 2');
        this.controlPanel.insertBefore(doNotAskAgainNode, this.controlPanel.firstChild);
        const doNotAskAgainLabel = document.createElement('label');
        doNotAskAgainLabel.classList.add('flex-line');
        doNotAskAgainNode.appendChild(doNotAskAgainLabel);
        doNotAskAgainLabel.textContent = common_1.nls.localize('arduino/dialog/dontAskAgain', "Don't ask again");
        this.doNotAskAgainCheckbox = document.createElement('input');
        this.doNotAskAgainCheckbox.setAttribute('align-self', 'center');
        doNotAskAgainLabel.appendChild(this.doNotAskAgainCheckbox);
        this.doNotAskAgainCheckbox.type = 'checkbox';
    }
    async accept() {
        if (!this.resolve) {
            return;
        }
        this.acceptCancellationSource.cancel();
        this.acceptCancellationSource = new cancellation_1.CancellationTokenSource();
        const token = this.acceptCancellationSource.token;
        const value = this.value;
        const error = await this.isValid(value, 'open');
        if (token.isCancellationRequested) {
            return;
        }
        if (!dialogs_1.DialogError.getResult(error)) {
            this.setErrorMessage(error);
        }
        else {
            if (this.doNotAskAgainCheckbox.checked) {
                await this.props.onAccept();
            }
            this.resolve(value);
            widgets_1.Widget.detach(this);
        }
    }
    setErrorMessage(error) {
        if (this.acceptButton) {
            this.acceptButton.disabled = !dialogs_1.DialogError.getResult(error);
        }
    }
};
DoNotAskAgainConfirmDialog = __decorate([
    inversify_1.injectable(),
    __param(0, inversify_1.inject(DoNotAskAgainDialogProps)),
    __metadata("design:paramtypes", [DoNotAskAgainDialogProps])
], DoNotAskAgainConfirmDialog);
exports.DoNotAskAgainConfirmDialog = DoNotAskAgainConfirmDialog;
//# sourceMappingURL=do-not-ask-again-dialog.js.map