"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelectBoardComponent = void 0;
const common_1 = require("@theia/core/lib/common");
const React = require("react");
const arduino_select_1 = require("../../widgets/arduino-select");
exports.SelectBoardComponent = ({ availableBoards, updatableFqbns, onBoardSelect, selectedBoard, busy, }) => {
    var _a, _b;
    const [selectOptions, setSelectOptions] = React.useState([]);
    const [selectBoardPlaceholder, setSelectBoardPlaceholder] = React.useState('');
    const selectOption = React.useCallback((boardOpt) => {
        onBoardSelect((boardOpt &&
            availableBoards.find((board) => board.fqbn === boardOpt.value)) ||
            null);
    }, [availableBoards, onBoardSelect]);
    React.useEffect(() => {
        // if there is activity going on, skip updating the boards (avoid flickering)
        if (busy) {
            return;
        }
        let placeholderTxt = common_1.nls.localize('arduino/certificate/selectBoard', 'Select a board...');
        let selBoard = -1;
        const updatableBoards = availableBoards.filter((board) => board.port && board.fqbn && updatableFqbns.includes(board.fqbn));
        const boardsList = updatableBoards.map((board, i) => {
            var _a, _b;
            if (board.selected) {
                selBoard = i;
            }
            return {
                label: common_1.nls.localize('arduino/certificate/boardAtPort', '{0} at {1}', board.name, (_b = (_a = board.port) === null || _a === void 0 ? void 0 : _a.address) !== null && _b !== void 0 ? _b : ''),
                value: board.fqbn || '',
            };
        });
        if (boardsList.length === 0) {
            placeholderTxt = common_1.nls.localize('arduino/certificate/noSupportedBoardConnected', 'No supported board connected');
        }
        setSelectBoardPlaceholder(placeholderTxt);
        setSelectOptions(boardsList);
        if (selectedBoard) {
            selBoard = boardsList
                .map((boardOpt) => boardOpt.value)
                .indexOf(selectedBoard.fqbn || '');
        }
        selectOption(boardsList[selBoard] || null);
    }, [busy, availableBoards, selectOption, updatableFqbns, selectedBoard]);
    return (React.createElement(arduino_select_1.ArduinoSelect, { id: "board-select", menuPosition: "fixed", isDisabled: selectOptions.length === 0 || busy, placeholder: selectBoardPlaceholder, options: selectOptions, value: (selectedBoard && {
            value: selectedBoard.fqbn,
            label: common_1.nls.localize('arduino/certificate/boardAtPort', '{0} at {1}', selectedBoard.name, (_b = (_a = selectedBoard.port) === null || _a === void 0 ? void 0 : _a.address) !== null && _b !== void 0 ? _b : ''),
        }) ||
            null, tabSelectsValue: false, onChange: selectOption }));
};
//# sourceMappingURL=select-board-components.js.map