"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateListComponent = void 0;
const React = require("react");
exports.CertificateListComponent = ({ certificates, selectedCerts, setSelectedCerts, openContextMenu, }) => {
    const handleOnChange = (event) => {
        const target = event.target;
        const newSelectedCerts = selectedCerts.filter((cert) => cert !== target.name);
        if (target.checked) {
            newSelectedCerts.push(target.name);
        }
        setSelectedCerts(newSelectedCerts);
    };
    const handleContextMenu = (event, cert) => {
        openContextMenu(event.clientX, event.clientY, cert);
    };
    return (React.createElement("div", { className: "certificate-list" }, certificates.map((certificate, i) => (React.createElement("label", { key: i, className: "certificate-row", onContextMenu: (e) => handleContextMenu(e, certificate) },
        React.createElement("span", { className: "fl1" }, certificate),
        React.createElement("input", { type: "checkbox", name: certificate, checked: selectedCerts.includes(certificate), onChange: handleOnChange }))))));
};
//# sourceMappingURL=certificate-list.js.map