"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CertificateAddComponent = void 0;
const common_1 = require("@theia/core/lib/common");
const React = require("react");
exports.CertificateAddComponent = ({ addCertificate, }) => {
    const [value, setValue] = React.useState('');
    const handleChange = React.useCallback((event) => {
        setValue(event.target.value);
    }, []);
    return (React.createElement("form", { className: "certificate-add", onSubmit: (event) => {
            event.preventDefault();
            event.stopPropagation();
            addCertificate(value);
            setValue('');
        } },
        React.createElement("label", null,
            React.createElement("div", null, common_1.nls.localize('arduino/certificate/addURL', 'Add URL to fetch SSL certificate')),
            React.createElement("input", { className: "theia-input", placeholder: common_1.nls.localize('arduino/certificate/enterURL', 'Enter URL'), type: "text", name: "add", onChange: handleChange, value: value }))));
};
//# sourceMappingURL=certificate-add-new.js.map