"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateError = exports.Create = void 0;
var Create;
(function (Create) {
    Create.arduino_secrets_file = 'arduino_secrets.h';
    Create.do_not_sync_files = ['.theia', 'sketch.json'];
    let Resource;
    (function (Resource) {
        function is(arg) {
            return (!!arg &&
                'name' in arg &&
                typeof arg['name'] === 'string' &&
                'path' in arg &&
                typeof arg['path'] === 'string' &&
                'type' in arg &&
                typeof arg['type'] === 'string' &&
                'modified_at' in arg &&
                typeof arg['modified_at'] === 'string' &&
                (arg['type'] === 'sketch' ||
                    arg['type'] === 'folder' ||
                    arg['type'] === 'file'));
        }
        Resource.is = is;
    })(Resource = Create.Resource || (Create.Resource = {}));
})(Create = exports.Create || (exports.Create = {}));
class CreateError extends Error {
    constructor(message, status, details) {
        super(message);
        this.status = status;
        this.details = details;
        Object.setPrototypeOf(this, CreateError.prototype);
    }
}
exports.CreateError = CreateError;
//# sourceMappingURL=typings.js.map