"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateUri = void 0;
const vscode_uri_1 = require("vscode-uri");
const uri_1 = require("@theia/core/lib/common/uri");
const create_paths_1 = require("./create-paths");
var CreateUri;
(function (CreateUri) {
    CreateUri.scheme = 'arduino-create';
    CreateUri.root = toUri(create_paths_1.posix.sep);
    function toUri(posixPathOrResource) {
        const posixPath = typeof posixPathOrResource === 'string'
            ? posixPathOrResource
            : create_paths_1.toPosixPath(posixPathOrResource.path);
        return new uri_1.default(vscode_uri_1.URI.parse(posixPath).with({ scheme: CreateUri.scheme, authority: 'create' }));
    }
    CreateUri.toUri = toUri;
    function is(uri) {
        return uri.scheme === CreateUri.scheme;
    }
    CreateUri.is = is;
    function equals(left, right) {
        return is(left) && is(right) && left.toString() === right.toString();
    }
    CreateUri.equals = equals;
    function parent(uri) {
        if (!is(uri)) {
            throw new Error(`Invalid URI scheme. Expected '${CreateUri.scheme}' got '${uri.scheme}' instead.`);
        }
        if (equals(uri, CreateUri.root)) {
            return uri;
        }
        return toUri(create_paths_1.parentPosix(uri.path.toString()));
    }
    CreateUri.parent = parent;
})(CreateUri = exports.CreateUri || (exports.CreateUri = {}));
//# sourceMappingURL=create-uri.js.map