"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var CreateApi_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CreateApi = exports.Utf8ArrayToStr = exports.ResponseResultProvider = void 0;
const inversify_1 = require("inversify");
const createPaths = require("./create-paths");
const create_paths_1 = require("./create-paths");
const cloud_sketch_cache_1 = require("../widgets/cloud-sketchbook/cloud-sketch-cache");
const typings_1 = require("./typings");
var ResponseResultProvider;
(function (ResponseResultProvider) {
    ResponseResultProvider.NOOP = async () => undefined;
    ResponseResultProvider.TEXT = (response) => response.text();
    ResponseResultProvider.JSON = (response) => response.json();
})(ResponseResultProvider = exports.ResponseResultProvider || (exports.ResponseResultProvider = {}));
function Utf8ArrayToStr(array) {
    let out, i, c;
    let char2, char3;
    out = '';
    const len = array.length;
    i = 0;
    while (i < len) {
        c = array[i++];
        switch (c >> 4) {
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
            case 6:
            case 7:
                // 0xxxxxxx
                out += String.fromCharCode(c);
                break;
            case 12:
            case 13:
                // 110x xxxx   10xx xxxx
                char2 = array[i++];
                out += String.fromCharCode(((c & 0x1f) << 6) | (char2 & 0x3f));
                break;
            case 14:
                // 1110 xxxx  10xx xxxx  10xx xxxx
                char2 = array[i++];
                char3 = array[i++];
                out += String.fromCharCode(((c & 0x0f) << 12) | ((char2 & 0x3f) << 6) | ((char3 & 0x3f) << 0));
                break;
        }
    }
    return out;
}
exports.Utf8ArrayToStr = Utf8ArrayToStr;
let CreateApi = CreateApi_1 = class CreateApi {
    init(authenticationService, arduinoPreferences) {
        this.authenticationService = authenticationService;
        this.arduinoPreferences = arduinoPreferences;
        return this;
    }
    getSketchSecretStat(sketch) {
        return {
            href: `${sketch.href}${create_paths_1.posix.sep}${typings_1.Create.arduino_secrets_file}`,
            modified_at: sketch.modified_at,
            created_at: sketch.created_at,
            name: `${typings_1.Create.arduino_secrets_file}`,
            path: `${sketch.path}${create_paths_1.posix.sep}${typings_1.Create.arduino_secrets_file}`,
            mimetype: 'text/x-c++src; charset=utf-8',
            type: 'file',
        };
    }
    async sketch(id) {
        const url = new URL(`${this.domain()}/sketches/byID/${id}`);
        url.searchParams.set('user_id', 'me');
        const headers = await this.headers();
        const result = await this.run(url, {
            method: 'GET',
            headers,
        });
        return result;
    }
    async sketches(limit = 50) {
        const url = new URL(`${this.domain()}/sketches`);
        url.searchParams.set('user_id', 'me');
        url.searchParams.set('limit', limit.toString());
        const headers = await this.headers();
        const result = { sketches: [] };
        let partialSketches = [];
        let currentOffset = 0;
        do {
            url.searchParams.set('offset', currentOffset.toString());
            partialSketches = (await this.run(url, {
                method: 'GET',
                headers,
            })).sketches;
            if (partialSketches.length != 0) {
                result.sketches = result.sketches.concat(partialSketches);
            }
            currentOffset = currentOffset + limit;
        } while (partialSketches.length != 0);
        result.sketches.forEach((sketch) => this.sketchCache.addSketch(sketch));
        return result.sketches;
    }
    async createSketch(posixPath, content = CreateApi_1.defaultInoContent) {
        const url = new URL(`${this.domain()}/sketches`);
        const headers = await this.headers();
        const payload = {
            ino: btoa(content),
            path: posixPath,
            user_id: 'me',
        };
        const init = {
            method: 'PUT',
            body: JSON.stringify(payload),
            headers,
        };
        const result = await this.run(url, init);
        return result;
    }
    async readDirectory(posixPath, options = {}) {
        const url = new URL(`${this.domain()}/files/d/$HOME/sketches_v2${posixPath}`);
        if (options.recursive) {
            url.searchParams.set('deep', 'true');
        }
        if (options.match) {
            url.searchParams.set('name_like', options.match);
        }
        const headers = await this.headers();
        const cachedSketch = this.sketchCache.getSketch(posixPath);
        const sketchPromise = options.skipSketchCache
            ? (cachedSketch && this.sketch(cachedSketch.id)) || Promise.resolve(null)
            : Promise.resolve(this.sketchCache.getSketch(posixPath));
        return Promise.all([
            sketchPromise,
            this.run(url, {
                method: 'GET',
                headers,
            }),
        ])
            .then(async ([sketch, result]) => {
            if (posixPath.length && posixPath !== create_paths_1.posix.sep) {
                if (sketch && sketch.secrets && sketch.secrets.length > 0) {
                    result.push(this.getSketchSecretStat(sketch));
                }
            }
            return result.filter((res) => !typings_1.Create.do_not_sync_files.includes(res.name));
        })
            .catch((reason) => {
            if ((reason === null || reason === void 0 ? void 0 : reason.status) === 404)
                return [];
            else
                throw reason;
        });
    }
    async createDirectory(posixPath) {
        const url = new URL(`${this.domain()}/files/d/$HOME/sketches_v2${posixPath}`);
        const headers = await this.headers();
        await this.run(url, {
            method: 'POST',
            headers,
        });
    }
    async stat(posixPath) {
        // The root is a directory read.
        if (posixPath === '/') {
            throw new Error('Stating the root is not supported');
        }
        // The RESTful API has different endpoints for files and directories.
        // The RESTful API does not provide specific error codes, only HTP 500.
        // We query the parent directory and look for the file with the last segment.
        const parentPosixPath = createPaths.parentPosix(posixPath);
        const basename = createPaths.basename(posixPath);
        let resources;
        if (basename === typings_1.Create.arduino_secrets_file) {
            const sketch = this.sketchCache.getSketch(parentPosixPath);
            resources = sketch ? [this.getSketchSecretStat(sketch)] : [];
        }
        else {
            resources = await this.readDirectory(parentPosixPath, {
                match: basename,
            });
        }
        const resource = resources.find(({ path }) => createPaths.splitSketchPath(path)[1] === posixPath);
        if (!resource) {
            throw new typings_1.CreateError(`Not found: ${posixPath}.`, 404);
        }
        return resource;
    }
    async toggleSecretsInclude(path, data, mode) {
        const includeString = `#include "${typings_1.Create.arduino_secrets_file}"`;
        const includeRegexp = new RegExp(includeString + '\\s*', 'g');
        const basename = createPaths.basename(path);
        if (mode === 'add') {
            const doesIncludeSecrets = includeRegexp.test(data);
            if (doesIncludeSecrets) {
                return data;
            }
            const sketch = this.sketchCache.getSketch(createPaths.parentPosix(path));
            if (sketch &&
                (sketch.name + '.ino' === basename ||
                    sketch.name + '.pde' === basename) &&
                sketch.secrets &&
                sketch.secrets.length > 0) {
                return includeString + '\n' + data;
            }
        }
        else if (mode === 'remove') {
            return data.replace(includeRegexp, '');
        }
        return data;
    }
    async readFile(posixPath) {
        const basename = createPaths.basename(posixPath);
        if (basename === typings_1.Create.arduino_secrets_file) {
            const parentPosixPath = createPaths.parentPosix(posixPath);
            //retrieve the sketch id from the cache
            const cacheSketch = this.sketchCache.getSketch(parentPosixPath);
            if (!cacheSketch) {
                throw new Error(`Unable to find sketch ${parentPosixPath} in cache`);
            }
            // get a fresh copy of the sketch in order to guarantee fresh secrets
            const sketch = await this.sketch(cacheSketch.id);
            if (!sketch) {
                throw new Error(`Unable to get a fresh copy of the sketch ${cacheSketch.id}`);
            }
            this.sketchCache.addSketch(sketch);
            let file = '';
            if (sketch && sketch.secrets) {
                for (const item of sketch.secrets) {
                    file += `#define ${item.name} "${item.value}"\r\n`;
                }
            }
            return file;
        }
        const url = new URL(`${this.domain()}/files/f/$HOME/sketches_v2${posixPath}`);
        const headers = await this.headers();
        const result = await this.run(url, {
            method: 'GET',
            headers,
        });
        let { data } = result;
        // add includes to main arduino file
        data = await this.toggleSecretsInclude(posixPath, atob(data), 'add');
        return data;
    }
    async writeFile(posixPath, content) {
        const basename = createPaths.basename(posixPath);
        if (basename === typings_1.Create.arduino_secrets_file) {
            const parentPosixPath = createPaths.parentPosix(posixPath);
            const sketch = this.sketchCache.getSketch(parentPosixPath);
            if (sketch) {
                const url = new URL(`${this.domain()}/sketches/${sketch.id}`);
                const headers = await this.headers();
                // parse the secret file
                const secrets = (typeof content === 'string' ? content : Utf8ArrayToStr(content))
                    .split(/\r?\n/)
                    .reduce((prev, curr) => {
                    // check if the line contains a secret
                    const secret = curr.split('SECRET_')[1] || null;
                    if (!secret) {
                        return prev;
                    }
                    const regexp = /(\S*)\s+([\S\s]*)/g;
                    const tokens = regexp.exec(secret) || [];
                    const name = tokens[1].length > 0 ? `SECRET_${tokens[1]}` : '';
                    let value = '';
                    if (tokens[2].length > 0) {
                        value = JSON.parse(JSON.stringify(tokens[2].replace(/^['"]?/g, '').replace(/['"]?$/g, '')));
                    }
                    if (name.length === 0) {
                        return prev;
                    }
                    return [...prev, { name, value }];
                }, []);
                const payload = {
                    id: sketch.id,
                    libraries: sketch.libraries,
                    secrets: { data: secrets },
                };
                // replace the sketch in the cache with the one we are pushing
                // TODO: we should do a get after the POST, in order to be sure the cache
                // is updated the most recent metadata
                this.sketchCache.addSketch(sketch);
                const init = {
                    method: 'POST',
                    body: JSON.stringify(payload),
                    headers,
                };
                await this.run(url, init);
            }
            return;
        }
        // do not upload "do_not_sync" files/directoris and their descendants
        const segments = posixPath.split(create_paths_1.posix.sep) || [];
        if (segments.some((segment) => typings_1.Create.do_not_sync_files.includes(segment))) {
            return;
        }
        const url = new URL(`${this.domain()}/files/f/$HOME/sketches_v2${posixPath}`);
        const headers = await this.headers();
        let data = typeof content === 'string' ? content : Utf8ArrayToStr(content);
        data = await this.toggleSecretsInclude(posixPath, data, 'remove');
        const payload = { data: btoa(data) };
        const init = {
            method: 'POST',
            body: JSON.stringify(payload),
            headers,
        };
        await this.run(url, init);
    }
    async deleteFile(posixPath) {
        await this.delete(posixPath, 'f');
    }
    async deleteDirectory(posixPath) {
        await this.delete(posixPath, 'd');
    }
    async delete(posixPath, type) {
        const url = new URL(`${this.domain()}/files/${type}/$HOME/sketches_v2${posixPath}`);
        const headers = await this.headers();
        await this.run(url, {
            method: 'DELETE',
            headers,
        });
    }
    async rename(fromPosixPath, toPosixPath) {
        const url = new URL(`${this.domain('v3')}/files/mv`);
        const headers = await this.headers();
        const payload = {
            from: `$HOME/sketches_v2${fromPosixPath}`,
            to: `$HOME/sketches_v2${toPosixPath}`,
        };
        const init = {
            method: 'POST',
            body: JSON.stringify(payload),
            headers,
        };
        await this.run(url, init, ResponseResultProvider.NOOP);
    }
    async editSketch({ id, params, }) {
        const url = new URL(`${this.domain()}/sketches/${id}`);
        const headers = await this.headers();
        const result = await this.run(url, {
            method: 'POST',
            body: JSON.stringify(Object.assign({ id }, params)),
            headers,
        });
        return result;
    }
    async copy(fromPosixPath, toPosixPath) {
        const payload = {
            from: `$HOME/sketches_v2${fromPosixPath}`,
            to: `$HOME/sketches_v2${toPosixPath}`,
        };
        const url = new URL(`${this.domain('v3')}/files/cp`);
        const headers = await this.headers();
        const init = {
            method: 'POST',
            body: JSON.stringify(payload),
            headers,
        };
        await this.run(url, init, ResponseResultProvider.NOOP);
    }
    async run(requestInfo, init, resultProvider = ResponseResultProvider.JSON) {
        const response = await fetch(requestInfo instanceof URL ? requestInfo.toString() : requestInfo, init);
        if (!response.ok) {
            let details = undefined;
            try {
                details = await response.json();
            }
            catch (e) {
                console.error('Cloud not get the error details.', e);
            }
            const { statusText, status } = response;
            throw new typings_1.CreateError(statusText, status, details);
        }
        const result = await resultProvider(response);
        return result;
    }
    async headers() {
        const token = await this.token();
        return {
            'content-type': 'application/json',
            accept: 'application/json',
            authorization: `Bearer ${token}`,
        };
    }
    domain(apiVersion = 'v2') {
        const endpoint = this.arduinoPreferences['arduino.cloud.sketchSyncEnpoint'];
        return `${endpoint}/${apiVersion}`;
    }
    async token() {
        var _a;
        return ((_a = this.authenticationService.session) === null || _a === void 0 ? void 0 : _a.accessToken) || '';
    }
};
__decorate([
    inversify_1.inject(cloud_sketch_cache_1.SketchCache),
    __metadata("design:type", cloud_sketch_cache_1.SketchCache)
], CreateApi.prototype, "sketchCache", void 0);
CreateApi = CreateApi_1 = __decorate([
    inversify_1.injectable()
], CreateApi);
exports.CreateApi = CreateApi;
(function (CreateApi) {
    CreateApi.defaultInoContent = `/*

*/

void setup() {
  
}

void loop() {
  
}

`;
})(CreateApi = exports.CreateApi || (exports.CreateApi = {}));
exports.CreateApi = CreateApi;
//# sourceMappingURL=create-api.js.map