"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var VerifySketch_1;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VerifySketch = void 0;
const inversify_1 = require("inversify");
const event_1 = require("@theia/core/lib/common/event");
const protocol_1 = require("../../common/protocol");
const arduino_menus_1 = require("../menu/arduino-menus");
const arduino_toolbar_1 = require("../toolbar/arduino-toolbar");
const boards_data_store_1 = require("../boards/boards-data-store");
const boards_service_provider_1 = require("../boards/boards-service-provider");
const contribution_1 = require("./contribution");
const common_1 = require("@theia/core/lib/common");
let VerifySketch = VerifySketch_1 = class VerifySketch extends contribution_1.SketchContribution {
    constructor() {
        super(...arguments);
        this.onDidChangeEmitter = new event_1.Emitter();
        this.onDidChange = this.onDidChangeEmitter.event;
        this.verifyInProgress = false;
    }
    registerCommands(registry) {
        registry.registerCommand(VerifySketch_1.Commands.VERIFY_SKETCH, {
            execute: () => this.verifySketch(),
            isEnabled: () => !this.verifyInProgress,
        });
        registry.registerCommand(VerifySketch_1.Commands.EXPORT_BINARIES, {
            execute: () => this.verifySketch(true),
            isEnabled: () => !this.verifyInProgress,
        });
        registry.registerCommand(VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR, {
            isVisible: (widget) => arduino_toolbar_1.ArduinoToolbar.is(widget) && widget.side === 'left',
            isEnabled: () => !this.verifyInProgress,
            isToggled: () => this.verifyInProgress,
            execute: () => registry.executeCommand(VerifySketch_1.Commands.VERIFY_SKETCH.id),
        });
    }
    registerMenus(registry) {
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: VerifySketch_1.Commands.VERIFY_SKETCH.id,
            label: common_1.nls.localize('arduino/sketch/verifyOrCompile', 'Verify/Compile'),
            order: '0',
        });
        registry.registerMenuAction(arduino_menus_1.ArduinoMenus.SKETCH__MAIN_GROUP, {
            commandId: VerifySketch_1.Commands.EXPORT_BINARIES.id,
            label: common_1.nls.localize('arduino/sketch/exportBinary', 'Export Compiled Binary'),
            order: '4',
        });
    }
    registerKeybindings(registry) {
        registry.registerKeybinding({
            command: VerifySketch_1.Commands.VERIFY_SKETCH.id,
            keybinding: 'CtrlCmd+R',
        });
        registry.registerKeybinding({
            command: VerifySketch_1.Commands.EXPORT_BINARIES.id,
            keybinding: 'CtrlCmd+Alt+S',
        });
    }
    registerToolbarItems(registry) {
        registry.registerItem({
            id: VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR.id,
            command: VerifySketch_1.Commands.VERIFY_SKETCH_TOOLBAR.id,
            tooltip: common_1.nls.localize('arduino/sketch/verify', 'Verify'),
            priority: 0,
            onDidChange: this.onDidChange,
        });
    }
    async verifySketch(exportBinaries) {
        var _a;
        // even with buttons disabled, better to double check if a verify is already in progress
        if (this.verifyInProgress) {
            return;
        }
        // toggle the toolbar button and menu item state.
        // verifyInProgress will be set to false whether the compilation fails or not
        this.verifyInProgress = true;
        this.onDidChangeEmitter.fire();
        const sketch = await this.sketchServiceClient.currentSketch();
        if (!sketch) {
            return;
        }
        try {
            const { boardsConfig } = this.boardsServiceClientImpl;
            const [fqbn, sourceOverride] = await Promise.all([
                this.boardsDataStore.appendConfigToFqbn((_a = boardsConfig.selectedBoard) === null || _a === void 0 ? void 0 : _a.fqbn),
                this.sourceOverride(),
            ]);
            const verbose = this.preferences.get('arduino.compile.verbose');
            const compilerWarnings = this.preferences.get('arduino.compile.warnings');
            this.outputChannelManager.getChannel('Arduino').clear();
            await this.coreService.compile({
                sketchUri: sketch.uri,
                fqbn,
                optimizeForDebug: this.editorMode.compileForDebug,
                verbose,
                exportBinaries,
                sourceOverride,
                compilerWarnings,
            });
            this.messageService.info(common_1.nls.localize('arduino/sketch/doneCompiling', 'Done compiling.'), { timeout: 3000 });
        }
        catch (e) {
            let errorMessage = "";
            if (typeof e === "string") {
                errorMessage = e;
            }
            else {
                errorMessage = e.toString();
            }
            this.messageService.error(errorMessage);
        }
        finally {
            this.verifyInProgress = false;
            this.onDidChangeEmitter.fire();
        }
    }
};
__decorate([
    inversify_1.inject(protocol_1.CoreService),
    __metadata("design:type", Object)
], VerifySketch.prototype, "coreService", void 0);
__decorate([
    inversify_1.inject(boards_data_store_1.BoardsDataStore),
    __metadata("design:type", boards_data_store_1.BoardsDataStore)
], VerifySketch.prototype, "boardsDataStore", void 0);
__decorate([
    inversify_1.inject(boards_service_provider_1.BoardsServiceProvider),
    __metadata("design:type", boards_service_provider_1.BoardsServiceProvider)
], VerifySketch.prototype, "boardsServiceClientImpl", void 0);
VerifySketch = VerifySketch_1 = __decorate([
    inversify_1.injectable()
], VerifySketch);
exports.VerifySketch = VerifySketch;
(function (VerifySketch) {
    let Commands;
    (function (Commands) {
        Commands.VERIFY_SKETCH = {
            id: 'arduino-verify-sketch',
        };
        Commands.EXPORT_BINARIES = {
            id: 'arduino-export-binaries',
        };
        Commands.VERIFY_SKETCH_TOOLBAR = {
            id: 'arduino-verify-sketch--toolbar',
        };
    })(Commands = VerifySketch.Commands || (VerifySketch.Commands = {}));
})(VerifySketch = exports.VerifySketch || (exports.VerifySketch = {}));
exports.VerifySketch = VerifySketch;
//# sourceMappingURL=verify-sketch.js.map